/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumnList
extends QueryTreeNodeVector {
    protected boolean indexRow;
    protected long conglomerateId;
    int orderBySelect = 0;
    protected boolean forUpdate;
    private boolean countMismatchAllowed;
    private int initialListSize = 0;

    public void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.addElement(resultColumn);
    }

    public void appendResultColumns(ResultColumnList resultColumnList, boolean bl) {
        int n = this.size();
        int n2 = n + 1;
        int n3 = resultColumnList.size();
        for (int i = 0; i < n3; ++i) {
            ((ResultColumn)resultColumnList.elementAt(i)).setVirtualColumnId(n2);
            ++n2;
        }
        if (bl) {
            this.destructiveAppend(resultColumnList);
        } else {
            this.nondestructiveAppend(resultColumnList);
        }
    }

    public ResultColumn getResultColumn(int n) {
        ResultColumn resultColumn;
        if (n <= this.size() && (resultColumn = (ResultColumn)this.elementAt(n - 1)).getColumnPosition() == n) {
            return resultColumn;
        }
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            if (resultColumn2.getColumnPosition() != n) continue;
            return resultColumn2;
        }
        return null;
    }

    public ResultColumn getResultColumn(int n, ResultSetNode resultSetNode, int[] nArray) throws StandardException {
        if (n == -1) {
            return null;
        }
        ResultColumn resultColumn = null;
        ColumnReference columnReference = null;
        int[] nArray2 = new int[]{-1};
        for (int i = this.size() - 1; i >= 0; --i) {
            resultColumn = (ResultColumn)this.elementAt(i);
            if (!(resultColumn.getExpression() instanceof ColumnReference) || resultSetNode != (columnReference = (ColumnReference)resultColumn.getExpression()).getSourceResultSet(nArray2) || nArray2[0] != n) continue;
            nArray[0] = i + 1;
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getOrderByColumn(int n) {
        if (n == 0) {
            return null;
        }
        return this.getResultColumn(n);
    }

    public ResultColumn getResultColumn(String string) {
        return this.getResultColumn(string, true);
    }

    public ResultColumn getResultColumn(String string, boolean bl) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!string.equals(resultColumn.getName())) continue;
            if (bl) {
                resultColumn.setReferenced();
            }
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getResultColumn(int n, int n2, String string) {
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            ResultColumn resultColumn;
            ResultColumn resultColumn2 = resultColumn = (ResultColumn)this.elementAt(i);
            while (resultColumn2 != null) {
                ValueNode valueNode;
                ValueNode valueNode2 = resultColumn2.getExpression();
                if (valueNode2 instanceof VirtualColumnNode) {
                    valueNode = (VirtualColumnNode)valueNode2;
                    ResultSetNode resultSetNode = ((VirtualColumnNode)valueNode).getSourceResultSet();
                    if (resultSetNode instanceof FromTable) {
                        FromTable fromTable = (FromTable)resultSetNode;
                        if (fromTable.getTableNumber() == n) {
                            ColumnDescriptor columnDescriptor = resultColumn2.getTableColumnDescriptor();
                            if (columnDescriptor != null && columnDescriptor.getPosition() == n2 || ((VirtualColumnNode)valueNode).getSourceColumn().getColumnPosition() == n2) {
                                if (string.equals(((VirtualColumnNode)valueNode).getSourceColumn().getName())) {
                                    resultColumn.setReferenced();
                                    return resultColumn;
                                }
                                return null;
                            }
                            resultColumn2 = ((VirtualColumnNode)valueNode).getSourceColumn();
                            continue;
                        }
                        resultColumn2 = ((VirtualColumnNode)valueNode).getSourceColumn();
                        continue;
                    }
                    resultColumn2 = null;
                    continue;
                }
                if (valueNode2 instanceof ColumnReference) {
                    valueNode = (ColumnReference)valueNode2;
                    if (((ColumnReference)valueNode).getTableNumber() == n && ((ColumnReference)valueNode).getColumnNumber() == n2) {
                        resultColumn.setReferenced();
                        return resultColumn;
                    }
                    resultColumn2 = null;
                    continue;
                }
                resultColumn2 = null;
            }
        }
        return null;
    }

    public ResultColumn getResultColumn(String string, String string2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (string != null && (resultColumn.getTableName() == null || !string.equals(resultColumn.getTableName())) || !string2.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getAtMostOneResultColumn(ColumnReference columnReference, String string, boolean bl) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        String string2 = columnReference.getColumnName();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            if (!string2.equals(resultColumn2.getName()) || resultColumn2.isGenerated() && !bl) continue;
            if (resultColumn != null) {
                throw StandardException.newException("42Y34", (Object)string2, (Object)string);
            }
            resultColumn2.setReferenced();
            resultColumn = resultColumn2;
        }
        return resultColumn;
    }

    public ResultColumn getOrderByColumnToBind(String string, TableName tableName, int n, OrderByColumn orderByColumn) throws StandardException {
        int n2 = this.size();
        ResultColumn resultColumn = null;
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            if (tableName != null) {
                ColumnReference columnReference;
                ValueNode valueNode = resultColumn2.getExpression();
                if (!(valueNode instanceof ColumnReference) || !tableName.equals((columnReference = (ColumnReference)valueNode).getTableNameNode()) && n != columnReference.getTableNumber()) continue;
                bl = string.equals(resultColumn2.getSourceColumnName());
            } else {
                bl = resultColumn2.columnNameMatches(string);
            }
            if (!bl) continue;
            if (resultColumn == null) {
                resultColumn = resultColumn2;
                continue;
            }
            if (!resultColumn.isEquivalent(resultColumn2)) {
                throw StandardException.newException("42X79", string);
            }
            if (i < n2 - this.orderBySelect) continue;
            this.removeElement(resultColumn2);
            this.decOrderBySelect();
            orderByColumn.clearAddedColumnOffset();
            this.collapseVirtualColumnIdGap(resultColumn2.getColumnPosition());
            break;
        }
        return resultColumn;
    }

    private void collapseVirtualColumnIdGap(int n) {
        for (int i = 0; i < this.size(); ++i) {
            ((ResultColumn)this.elementAt(i)).collapseVirtualColumnIdGap(n);
        }
    }

    public ResultColumn findResultColumnForOrderBy(String string, TableName tableName) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            if (tableName != null) {
                ColumnReference columnReference;
                ValueNode valueNode = resultColumn2.getExpression();
                if (valueNode == null || !(valueNode instanceof ColumnReference) || !tableName.equals((columnReference = (ColumnReference)valueNode).getTableNameNode())) continue;
                bl = string.equals(resultColumn2.getSourceColumnName());
            } else {
                bl = resultColumn2.columnNameMatches(string);
            }
            if (!bl) continue;
            if (resultColumn == null) {
                resultColumn = resultColumn2;
                continue;
            }
            if (!resultColumn.isEquivalent(resultColumn2)) {
                throw StandardException.newException("42X79", string);
            }
            if (i < n - this.orderBySelect) continue;
        }
        return resultColumn;
    }

    void copyResultColumnNames(ResultColumnList resultColumnList) {
        int n = this.countMismatchAllowed ? resultColumnList.visibleSize() : this.visibleSize();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            resultColumn.setName(resultColumn2.getName());
            resultColumn.setNameGenerated(resultColumn2.isNameGenerated());
        }
    }

    public void bindExpressions(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.expandAllsAndNameColumns(fromList);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            valueNode = ((ResultColumn)valueNode).bindExpression(fromList, subqueryList, vector);
            this.setElementAt(valueNode, i);
        }
    }

    public void bindResultColumnsToExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).bindResultColumnToExpression();
        }
    }

    public void bindResultColumnsByName(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.bindResultColumnByName(tableDescriptor, i + 1);
        }
    }

    public FormatableBitSet bindResultColumnsByName(TableDescriptor tableDescriptor, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(tableDescriptor.getNumberOfColumns());
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.bindResultColumnByName(tableDescriptor, i + 1);
            int n2 = resultColumn.getColumnPosition() - 1;
            if (dMLStatementNode != null && formatableBitSet.isSet(n2)) {
                String string = resultColumn.getName();
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            formatableBitSet.set(n2);
        }
        return formatableBitSet;
    }

    public void bindResultColumnsByName(ResultColumnList resultColumnList, FromVTI fromVTI, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            String string = resultColumn.getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            ResultColumn resultColumn2 = resultColumnList.getResultColumn(null, resultColumn.getName());
            if (resultColumn2 == null) {
                throw StandardException.newException("42X14", (Object)resultColumn.getName(), (Object)fromVTI.getMethodCall().getJavaClassName());
            }
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(resultColumn.getName(), resultColumn2.getVirtualColumnId(), resultColumn2.getType(), null, null, null, null, 0L, 0L);
            resultColumn.setColumnDescriptor(null, columnDescriptor);
            resultColumn.setVirtualColumnId(i + 1);
        }
    }

    public void bindResultColumnsByPosition(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).bindResultColumnByPosition(tableDescriptor, i + 1);
        }
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            this.setElementAt(resultColumn.preprocess(n, fromList, subqueryList, predicateList), i);
        }
    }

    void checkStorableExpressions(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            ((ResultColumn)this.elementAt(i)).checkStorableExpression(resultColumn);
        }
    }

    public int[] getStreamStorableColIds(int n) throws StandardException {
        int n2;
        int n3 = 0;
        boolean[] blArray = new boolean[n];
        int n4 = this.size();
        for (n2 = 0; n2 < n4; ++n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!resultColumn.getTypeId().streamStorable()) continue;
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            blArray[columnDescriptor.getPosition() - 1] = true;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray[n5++] = i;
        }
        return nArray;
    }

    void checkStorableExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).checkStorableExpression();
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, false);
    }

    void generateNulls(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, true);
    }

    void generateCore(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, "getValueRow", "org.apache.derby.iapi.sql.execute.ExecRow", this.size());
        int n = this.size();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getConstructor();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!bl) {
                ValueNode valueNode = resultColumn.getExpression();
                if (valueNode instanceof VirtualColumnNode && !((VirtualColumnNode)valueNode).getCorrelated()) continue;
                if (resultColumn.getJoinResultSet() != null) {
                    ResultColumnList resultColumnList = resultColumn.getJoinResultSet().getResultColumns();
                    int n2 = resultColumn.getJoinResultSet().getResultSetNumber();
                    int n3 = -1;
                    int n4 = -1;
                    for (int j = 0; j < resultColumnList.size(); ++j) {
                        ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(j);
                        if (!resultColumn2.getName().equals(resultColumn.getUnderlyingOrAliasName())) continue;
                        if (resultColumn2.isRightOuterJoinUsingClause()) {
                            n3 = resultColumn2.getVirtualColumnId();
                            continue;
                        }
                        n4 = resultColumn2.getVirtualColumnId();
                    }
                    methodBuilder2.getField(localField);
                    methodBuilder2.push(i + 1);
                    String string = this.getTypeCompiler(DataTypeDescriptor.getBuiltInDataTypeDescriptor(16).getTypeId()).interfaceName();
                    String string2 = "org.apache.derby.iapi.types.DataValueDescriptor";
                    expressionClassBuilder.pushColumnReference(methodBuilder2, n2, n4);
                    methodBuilder2.cast(resultColumn.getTypeCompiler().interfaceName());
                    methodBuilder2.cast(string2);
                    methodBuilder2.callMethod((short)185, null, "isNullOp", string, 0);
                    methodBuilder2.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    methodBuilder2.push(true);
                    methodBuilder2.callMethod((short)185, null, "equals", "boolean", 1);
                    methodBuilder2.conditionalIf();
                    expressionClassBuilder.pushColumnReference(methodBuilder2, n2, n3);
                    methodBuilder2.cast(resultColumn.getTypeCompiler().interfaceName());
                    methodBuilder2.startElseCode();
                    expressionClassBuilder.pushColumnReference(methodBuilder2, n2, n4);
                    methodBuilder2.cast(resultColumn.getTypeCompiler().interfaceName());
                    methodBuilder2.completeConditional();
                    methodBuilder2.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                    methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                    continue;
                }
                if (valueNode instanceof ColumnReference && !((ColumnReference)valueNode).getCorrelated()) continue;
            }
            if (resultColumn.hasGenerationClause()) continue;
            if (!bl && resultColumn.getExpression() instanceof ConstantNode && !((ConstantNode)resultColumn.getExpression()).isNull() && !methodBuilder3.statementNumHitLimit(1)) {
                methodBuilder3.getField(localField);
                methodBuilder3.push(i + 1);
                resultColumn.generateExpression(expressionClassBuilder, methodBuilder3);
                methodBuilder3.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder3.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            methodBuilder2.getField(localField);
            methodBuilder2.push(i + 1);
            boolean bl2 = true;
            if (resultColumn.isAutoincrementGenerated()) {
                methodBuilder2.pushThis();
                methodBuilder2.push(resultColumn.getColumnPosition());
                methodBuilder2.push(resultColumn.getTableColumnDescriptor().getAutoincInc());
                methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getSetAutoincrementValue", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
                bl2 = false;
            } else if (bl || resultColumn.getExpression() instanceof ConstantNode && ((ConstantNode)resultColumn.getExpression()).isNull()) {
                methodBuilder2.getField(localField);
                methodBuilder2.push(i + 1);
                methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                expressionClassBuilder.generateNullWithExpress(methodBuilder2, resultColumn.getTypeCompiler(), resultColumn.getTypeServices().getCollationType());
            } else {
                resultColumn.generateExpression(expressionClassBuilder, methodBuilder2);
            }
            if (bl2) {
                methodBuilder2.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    public ExecRow buildEmptyRow() throws StandardException {
        int n = this.size();
        ExecRow execRow = this.getExecutionFactory().getValueRow(n);
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(n2++, dataValueDescriptor);
        }
        return execRow;
    }

    public ExecRow buildEmptyIndexRow(TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, StoreCostController storeCostController, DataDictionary dataDictionary) throws StandardException {
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        ExecRow execRow = this.getExecutionFactory().getValueRow(nArray.length + 1);
        for (int i = 0; i < nArray.length; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(i + 1, dataValueDescriptor);
        }
        RowLocation rowLocation = storeCostController.newRowLocationTemplate();
        execRow.setColumn(nArray.length + 1, rowLocation);
        return execRow;
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateHolder(expressionClassBuilder, methodBuilder, null, null);
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        expressionClassBuilder.pushMethodReference(methodBuilder, this.generateHolderMethod(expressionClassBuilder, formatableBitSet, formatableBitSet2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodBuilder generateHolderMethod(ExpressionClassBuilder expressionClassBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        String string;
        String string2;
        int n = -1;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.anySetBit();
            while (n2 != -1) {
                n = n2;
                n2 = formatableBitSet.anySetBit(n2);
            }
        } else {
            n = this.size() - 1;
        }
        MethodBuilder methodBuilder = expressionClassBuilder.newExprFun();
        if (this.indexRow) {
            string2 = "getIndexableRow";
            string = "org.apache.derby.iapi.sql.execute.ExecIndexRow";
        } else {
            string2 = "getValueRow";
            string = "org.apache.derby.iapi.sql.execute.ExecRow";
        }
        int n3 = this.size();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, string2, string, n + 1);
        int n4 = formatableBitSet != null ? formatableBitSet.anySetBit() : 0;
        for (int i = 0; i < n3; ++i) {
            Object object;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.getExpression() instanceof CurrentRowLocationNode) {
                RowLocation rowLocation;
                object = null;
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
                DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
                int n5 = dataDictionary.getCacheMode() == 1 ? 2 : 0;
                object = languageConnectionContext.getTransactionCompile().openConglomerate(this.conglomerateId, false, 0, 6, n5);
                try {
                    rowLocation = object.newRowLocationTemplate();
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                int n6 = expressionClassBuilder.addItem(rowLocation);
                methodBuilder.getField(localField);
                methodBuilder.push(n + 1);
                methodBuilder.pushThis();
                methodBuilder.push(n6);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getRowLocationTemplate", "org.apache.derby.iapi.types.RowLocation", 1);
                methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            if (formatableBitSet2 != null && formatableBitSet2.getNumBitsSet() != 0 && (object = resultColumn.getExpression()) instanceof VirtualColumnNode) continue;
            methodBuilder.getField(localField);
            methodBuilder.push(n4 + 1);
            resultColumn.generateHolder(expressionClassBuilder, methodBuilder);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
            if (formatableBitSet != null) {
                n4 = formatableBitSet.anySetBit(n4);
                continue;
            }
            ++n4;
        }
        methodBuilder.getField(localField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    private void genCreateRow(ExpressionClassBuilder expressionClassBuilder, LocalField localField, String string, String string2, int n) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, string, string2, 1);
        methodBuilder.setField(localField);
        methodBuilder.statementNumHitLimit(1);
    }

    public ResultColumnDescriptor[] makeResultDescriptors() {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            resultColumnDescriptorArray[i] = this.getExecutionFactory().getResultColumnDescriptor((ResultColumnDescriptor)((Object)this.elementAt(i)));
        }
        return resultColumnDescriptorArray;
    }

    public void expandAllsAndNameColumns(FromList fromList) throws StandardException {
        int n;
        boolean bl = false;
        for (n = 0; n < this.size(); ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (resultColumn instanceof AllResultColumn) {
                TableName tableName;
                bl = true;
                TableName tableName2 = resultColumn.getTableNameObject();
                if (tableName2 != null) {
                    String string = tableName2.getSchemaName();
                    String string2 = tableName2.getTableName();
                    tableName = this.makeTableName(string, string2);
                } else {
                    tableName = null;
                }
                ResultColumnList resultColumnList = fromList.expandAll(tableName);
                resultColumnList.nameAllResultColumns();
                this.removeElementAt(n);
                for (int i = 0; i < resultColumnList.size(); ++i) {
                    this.insertElementAt(resultColumnList.elementAt(i), n + i);
                }
                n += resultColumnList.size() - 1;
                this.markInitialSize();
                continue;
            }
            resultColumn.guaranteeColumnName();
        }
        if (bl) {
            n = this.size();
            for (int i = 0; i < n; ++i) {
                ((ResultColumn)this.elementAt(i)).setVirtualColumnId(i + 1);
            }
        }
    }

    public void nameAllResultColumns() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.guaranteeColumnName();
        }
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch()) continue;
            return false;
        }
        return true;
    }

    boolean columnTypesAndLengthsMatch(ResultColumnList resultColumnList) throws StandardException {
        boolean bl = true;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.isGenerated() || resultColumn2.isGenerated() || resultColumn.columnTypeAndLengthMatch(resultColumn2)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean nopProjection(ResultColumnList resultColumnList) {
        if (this.size() != resultColumnList.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = null;
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                resultColumn2 = ((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn();
            } else if (resultColumn.getExpression() instanceof ColumnReference) {
                resultColumn2 = ((ColumnReference)resultColumn.getExpression()).getSource();
            } else {
                return false;
            }
            ResultColumn resultColumn3 = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn2 == resultColumn3) continue;
            return false;
        }
        return true;
    }

    public ResultColumnList copyListAndObjects() throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = resultColumn.cloneMe();
            resultColumnList.addResultColumn(resultColumn2);
        }
        resultColumnList.copyOrderBySelect(this);
        return resultColumnList;
    }

    public void removeOrderByColumns() {
        int n = this.size() - 1;
        int n2 = 0;
        while (n2 < this.orderBySelect) {
            this.removeElementAt(n);
            ++n2;
            --n;
        }
        this.orderBySelect = 0;
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList) throws StandardException {
        this.genVirtualColumnNodes(resultSetNode, resultColumnList, true);
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            resultColumn.expression = (ValueNode)this.getNodeFactory().getNode(107, resultSetNode, resultColumnList.elementAt(i), ReuseFactory.getInteger(i + 1), this.getContextManager());
            if (!bl) continue;
            resultColumn.setReferenced();
        }
    }

    public void adjustVirtualColumnIds(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.adjustVirtualColumnId(n);
            ((VirtualColumnNode)resultColumn.getExpression()).columnId += n;
        }
    }

    public void doProjection() throws StandardException {
        int n;
        int n2 = 0;
        int n3 = this.size();
        ResultColumnList resultColumnList = new ResultColumnList();
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced() && resultColumn.getExpression() instanceof VirtualColumnNode && !((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn().isReferenced()) {
                resultColumnList.addElement(resultColumn);
                ++n2;
                continue;
            }
            if (n2 >= 1) {
                resultColumn.adjustVirtualColumnId(-n2);
            }
            resultColumn.setReferenced();
        }
        for (n = 0; n < resultColumnList.size(); ++n) {
            this.removeElement((ResultColumn)resultColumnList.elementAt(n));
        }
    }

    public String verifyUniqueNames(boolean bl) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (bl && resultColumn.isNameGenerated()) {
                throw StandardException.newException("42908");
            }
            String string = ((ResultColumn)this.elementAt(i)).getName();
            String string2 = hashtable.put(string, string);
            if (string2 == null || !string2.equals(string)) continue;
            return string;
        }
        return null;
    }

    public void propagateDCLInfo(ResultColumnList resultColumnList, String string) throws StandardException {
        if (resultColumnList.size() != this.size() && !resultColumnList.getCountMismatchAllowed() && this.visibleSize() != resultColumnList.visibleSize()) {
            throw StandardException.newException("42X32", string);
        }
        String string2 = resultColumnList.verifyUniqueNames(false);
        if (string2 != null) {
            throw StandardException.newException("42X33", string2);
        }
        this.copyResultColumnNames(resultColumnList);
    }

    void rejectParameters() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.rejectParameter();
        }
    }

    void rejectXMLValues() throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        for (int i = 1; i <= n; ++i) {
            if (i > this.initialListSize || (resultColumn = this.getResultColumn(i)) == null || resultColumn.getType() == null || !resultColumn.getType().getTypeId().isXMLTypeId()) continue;
            throw StandardException.newException("42Z71");
        }
    }

    public void setResultSetNumber(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ((ResultColumn)this.elementAt(i)).setResultSetNumber(n);
        }
    }

    public void setRedundant() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).setRedundant();
        }
    }

    public void checkColumnUpdateability(String[] stringArray, String string) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.updated() || resultColumn.foundInList(stringArray)) continue;
            throw StandardException.newException("42X31", (Object)resultColumn.getName(), (Object)string);
        }
    }

    public void setUnionResultExpression(ResultColumnList resultColumnList, int n, int n2, String string) throws StandardException {
        TableName tableName = (TableName)this.getNodeFactory().getNode(34, null, null, this.getContextManager());
        ContextManager contextManager = this.getContextManager();
        int n3 = this.visibleSize();
        for (int i = 0; i < n3; ++i) {
            TypeId typeId;
            TypeId typeId2;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            ValueNode valueNode = resultColumn.getExpression();
            ValueNode valueNode2 = resultColumn2.getExpression();
            if (!resultColumn2.isAutoincrementGenerated() && resultColumn.isAutoincrementGenerated()) {
                resultColumn.resetAutoincrementGenerated();
            }
            if ((typeId2 = valueNode.getTypeId()) == null || (typeId = valueNode2.getTypeId()) == null) continue;
            ClassFactory classFactory = this.getClassFactory();
            if (!this.unionCompatible(valueNode, valueNode2)) {
                throw StandardException.newException("42X61", (Object)typeId2.getSQLTypeName(), (Object)typeId.getSQLTypeName(), (Object)string);
            }
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices().getDominantType(valueNode2.getTypeServices(), classFactory);
            ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), tableName, this.getContextManager());
            columnReference.setType(dataTypeDescriptor);
            if (valueNode instanceof ColumnReference) {
                columnReference.copyFields((ColumnReference)valueNode);
            } else {
                columnReference.setNestingLevel(n2);
                columnReference.setSourceLevel(n2);
            }
            columnReference.setTableNumber(n);
            resultColumn.setExpression(columnReference);
            resultColumn.setType(resultColumn.getTypeServices().getDominantType(resultColumn2.getTypeServices(), classFactory));
            if (resultColumn.getName() == null || resultColumn.isNameGenerated() || resultColumn2.getName() == null) continue;
            if (resultColumn2.isNameGenerated()) {
                resultColumn.setName(resultColumn2.getName());
                resultColumn.setNameGenerated(true);
                continue;
            }
            if (resultColumn.getName().equals(resultColumn2.getName())) continue;
            resultColumn.setName(null);
            resultColumn.guaranteeColumnName();
            resultColumn.setNameGenerated(true);
        }
    }

    private boolean unionCompatible(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        TypeId typeId = valueNode.getTypeId();
        TypeId typeId2 = valueNode2.getTypeId();
        ClassFactory classFactory = this.getClassFactory();
        if (!valueNode.getTypeCompiler().storable(typeId2, classFactory) && !valueNode2.getTypeCompiler().storable(typeId, classFactory)) {
            return false;
        }
        return typeId.isBooleanTypeId() == typeId2.isBooleanTypeId();
    }

    public boolean isExactTypeAndLengthMatch(ResultColumnList resultColumnList) throws StandardException {
        int n = this.visibleSize();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.getTypeServices().isExactTypeAndLengthMatch(resultColumn2.getTypeServices())) continue;
            return false;
        }
        return true;
    }

    public boolean updateOverlaps(int[] nArray) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.updated()) continue;
            int n2 = resultColumn.getColumnPosition();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != n2) continue;
                return true;
            }
        }
        return false;
    }

    ResultColumn[] getSortedByPosition() {
        int n = this.size();
        Object[] objectArray = new ResultColumn[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = (ResultColumn)this.elementAt(i);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public int[] sortMe() {
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int[] nArray = new int[resultColumnArray.length];
        for (int i = 0; i < resultColumnArray.length; ++i) {
            nArray[i] = resultColumnArray[i].getColumnPosition();
        }
        return nArray;
    }

    public ResultColumnList expandToAll(TableDescriptor tableDescriptor, TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int n = 0;
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn;
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            if (n < resultColumnArray.length && columnDescriptor.getPosition() == resultColumnArray[n].getColumnPosition()) {
                resultColumn = resultColumnArray[n];
                ++n;
            } else {
                resultColumn = this.makeColumnReferenceFromName(tableName, columnDescriptor.getColumnName());
                resultColumn.bindResultColumnByPosition(tableDescriptor, columnDescriptor.getPosition());
            }
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            throw StandardException.newException("42X07");
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            resultColumn2.typeUntypedNullExpression(resultColumn);
        }
    }

    void markUpdated() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).markUpdated();
        }
    }

    void markUpdatableByCursor() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((ResultColumn)this.elementAt(i)).getSourceTableName() == null) continue;
            ((ResultColumn)this.elementAt(i)).markUpdatableByCursor();
        }
    }

    public String verifyCreateConstraintColumnList(TableElementList tableElementList) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)this.elementAt(i)).getName();
            if (tableElementList.containsColumnName(string)) continue;
            return string;
        }
        return null;
    }

    public void exportNames(String[] stringArray) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((ResultColumn)this.elementAt(i)).getName();
        }
    }

    public ResultColumn findParentResultColumn(ResultColumn resultColumn) {
        ResultColumn resultColumn2 = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode;
            ResultColumn resultColumn3 = (ResultColumn)this.elementAt(i);
            if (resultColumn3.getExpression() instanceof ColumnReference) {
                valueNode = (ColumnReference)resultColumn3.getExpression();
                if (((ColumnReference)valueNode).getSource() != resultColumn) continue;
                resultColumn2 = resultColumn3;
                break;
            }
            if (!(resultColumn3.getExpression() instanceof VirtualColumnNode) || ((VirtualColumnNode)(valueNode = (VirtualColumnNode)resultColumn3.getExpression())).getSourceColumn() != resultColumn) continue;
            resultColumn2 = resultColumn3;
            break;
        }
        return resultColumn2;
    }

    void markUpdated(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            ResultColumn resultColumn2 = this.getResultColumn(resultColumn.getName());
            if (resultColumn2 == null) continue;
            resultColumn2.markUpdated();
        }
    }

    void markColumnsInSelectListUpdatableByCursor(Vector vector) {
        this.commonCodeForUpdatableByCursor(vector, true);
    }

    private void commonCodeForUpdatableByCursor(Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            this.markUpdatableByCursor();
        } else {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                ResultColumn resultColumn = this.getResultColumn(string);
                if (resultColumn == null && bl) continue;
                resultColumn.markUpdatableByCursor();
            }
        }
    }

    void markUpdatableByCursor(Vector vector) {
        this.commonCodeForUpdatableByCursor(vector, false);
    }

    boolean updatableByCursor(int n) {
        return this.getResultColumn(n).updatableByCursor();
    }

    public boolean isCloneable() {
        boolean bl = true;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.getExpression().isCloneable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.getExpression() == null) continue;
            resultColumn.setExpression(resultColumn.getExpression().remapColumnReferencesToExpressions());
        }
    }

    void setIndexRow(long l, boolean bl) {
        this.indexRow = true;
        this.conglomerateId = l;
        this.forUpdate = bl;
    }

    public boolean hasConsistentTypeInfo() throws StandardException {
        boolean bl = true;
        return bl;
    }

    public boolean containsAllResultColumn() {
        boolean bl = false;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.elementAt(i) instanceof AllResultColumn)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int countReferencedColumns() {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isReferenced()) continue;
            ++n;
        }
        return n;
    }

    public void recordColumnReferences(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isReferenced()) continue;
            nArray[n2++] = i + n;
        }
    }

    public int getPosition(String string, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!string.equals(resultColumn.getName())) continue;
            return i + n;
        }
        return -1;
    }

    public void recordColumnReferences(boolean[] blArray, JBitSet[] jBitSetArray, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!(resultColumn.getExpression() instanceof ColumnReference)) continue;
            int n3 = ((ColumnReference)resultColumn.getExpression()).getColumnNumber();
            blArray[n3] = true;
            jBitSetArray[n].set(n3);
        }
    }

    int allTopCRsFromSameTable() {
        int n = -1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ValueNode valueNode = resultColumn.getExpression();
            if (!(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)valueNode;
            if (n == -1) {
                n = columnReference.getTableNumber();
                continue;
            }
            if (n == columnReference.getTableNumber()) continue;
            return -1;
        }
        return n;
    }

    public void clearColumnReferences() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isReferenced()) continue;
            resultColumn.setUnreferenced();
        }
    }

    public void copyReferencedColumnsToNewList(ResultColumnList resultColumnList) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isReferenced()) continue;
            resultColumnList.addElement(resultColumn);
        }
    }

    public void copyColumnsToNewList(ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!formatableBitSet.isSet(resultColumn.getColumnPosition())) continue;
            resultColumnList.addElement(resultColumn);
        }
    }

    public FormatableBitSet getColumnReferenceMap() {
        FormatableBitSet formatableBitSet = new FormatableBitSet(this.size());
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isReferenced()) continue;
            formatableBitSet.set(i);
        }
        return formatableBitSet;
    }

    void pullVirtualIsReferenced() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.pullVirtualIsReferenced();
        }
    }

    public void clearTableNames() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.clearTableName();
        }
    }

    protected void setCountMismatchAllowed(boolean bl) {
        this.countMismatchAllowed = bl;
    }

    protected boolean getCountMismatchAllowed() {
        return this.countMismatchAllowed;
    }

    public int getTotalColumnSize() {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n += ((ResultColumn)this.elementAt(i)).getMaximumColumnSize();
        }
        return n;
    }

    public void createListFromResultSetMetaData(ResultSetMetaData resultSetMetaData, TableName tableName, String string) throws StandardException {
        try {
            int n = resultSetMetaData.getColumnCount();
            if (n <= 0) {
                throw StandardException.newException("42X57", (Object)string, (Object)String.valueOf(n));
            }
            for (int i = 1; i <= n; ++i) {
                TypeId typeId;
                boolean bl = resultSetMetaData.isNullable(i) != 0;
                int n2 = resultSetMetaData.getColumnType(i);
                switch (n2) {
                    case 1111: 
                    case 2000: {
                        typeId = TypeId.getUserDefinedTypeId(resultSetMetaData.getColumnTypeName(i), false);
                        break;
                    }
                    default: {
                        typeId = TypeId.getBuiltInTypeId(n2);
                    }
                }
                if (typeId == null) {
                    throw StandardException.newException("42Y23", Integer.toString(i));
                }
                int n3 = typeId.variableLength() ? resultSetMetaData.getColumnDisplaySize(i) : (n2 == -1 || n2 == -4 ? Integer.MAX_VALUE : 0);
                int n4 = typeId.isDecimalTypeId() ? resultSetMetaData.getPrecision(i) : 0;
                int n5 = typeId.isDecimalTypeId() ? resultSetMetaData.getScale(i) : 0;
                DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, n4, n5, bl, n3);
                this.addColumn(tableName, resultSetMetaData.getColumnName(i), dataTypeDescriptor);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof StandardException) {
                throw (StandardException)throwable;
            }
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public void addColumn(TableName tableName, String string, DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, string, tableName, dataTypeDescriptor, this.getContextManager());
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, valueNode, this.getContextManager());
        resultColumn.setType(dataTypeDescriptor);
        this.addResultColumn(resultColumn);
    }

    public void addRCForRID() throws StandardException {
        CurrentRowLocationNode currentRowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", currentRowLocationNode, this.getContextManager());
        resultColumn.markGenerated();
        this.addResultColumn(resultColumn);
    }

    public void markAllUnreferenced() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.setUnreferenced();
        }
    }

    boolean allExpressionsAreColumns(ResultSetNode resultSetNode) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.isRightOuterJoinUsingClause()) {
                return false;
            }
            ValueNode valueNode2 = resultColumn.getExpression();
            if (!(valueNode2 instanceof VirtualColumnNode) && !(valueNode2 instanceof ColumnReference)) {
                return false;
            }
            if (valueNode2 instanceof VirtualColumnNode && ((VirtualColumnNode)(valueNode = (VirtualColumnNode)valueNode2)).getSourceResultSet() != resultSetNode) {
                ((VirtualColumnNode)valueNode).setCorrelated();
                return false;
            }
            if (!(valueNode2 instanceof ColumnReference) || !((ColumnReference)(valueNode = (ColumnReference)valueNode2)).getCorrelated()) continue;
            return false;
        }
        return true;
    }

    ColumnMapping mapSourceColumns() {
        int[] nArray = new int[this.size()];
        boolean[] blArray = new boolean[this.size()];
        HashMap hashMap = new HashMap();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn;
            ValueNode valueNode;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(i);
            if (resultColumn2.getExpression() instanceof VirtualColumnNode) {
                valueNode = (VirtualColumnNode)resultColumn2.getExpression();
                if (((VirtualColumnNode)valueNode).getCorrelated()) {
                    nArray[i] = -1;
                    continue;
                }
                resultColumn = ((VirtualColumnNode)valueNode).getSourceColumn();
                ResultColumnList.updateArrays(nArray, blArray, hashMap, resultColumn, i);
                continue;
            }
            if (resultColumn2.isRightOuterJoinUsingClause()) {
                nArray[i] = -1;
                continue;
            }
            if (resultColumn2.getExpression() instanceof ColumnReference) {
                valueNode = (ColumnReference)resultColumn2.getExpression();
                if (((ColumnReference)valueNode).getCorrelated()) {
                    nArray[i] = -1;
                    continue;
                }
                resultColumn = ((ColumnReference)valueNode).getSource();
                ResultColumnList.updateArrays(nArray, blArray, hashMap, resultColumn, i);
                continue;
            }
            nArray[i] = -1;
        }
        ColumnMapping columnMapping = new ColumnMapping(nArray, blArray);
        return columnMapping;
    }

    public void setNullability(boolean bl) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.setNullability(bl);
        }
    }

    FormatableBitSet getReferencedFormatableBitSet(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = 0;
        int n3 = this.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3);
        if (bl) {
            if (bl2) {
                for (int i = 0; i < n3; ++i) {
                    formatableBitSet.set(i);
                }
                return formatableBitSet;
            }
            return null;
        }
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced() || bl3 && !(resultColumn.getExpression() instanceof BaseColumnNode)) continue;
            formatableBitSet.set(n);
            ++n2;
        }
        if (n2 != n || bl2) {
            return formatableBitSet;
        }
        return null;
    }

    ResultColumnList compactColumns(boolean bl, boolean bl2) throws StandardException {
        int n;
        int n2 = 0;
        if (bl) {
            return this;
        }
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n3 = this.size();
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced()) continue;
            resultColumnList.addResultColumn(resultColumn);
            ++n2;
        }
        if (n2 != n || bl2) {
            return resultColumnList;
        }
        return this;
    }

    void removeJoinColumns(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            if (resultColumn2 == null) continue;
            this.removeElement(resultColumn2);
        }
    }

    ResultColumnList getJoinColumns(ResultColumnList resultColumnList) throws StandardException {
        ResultColumnList resultColumnList2 = new ResultColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            if (resultColumn2 == null) {
                throw StandardException.newException("42X04", string);
            }
            resultColumnList2.addElement(resultColumn2);
        }
        return resultColumnList2;
    }

    void resetVirtualColumnIds() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((ResultColumn)this.elementAt(i)).setVirtualColumnId(i + 1);
        }
    }

    boolean reusableResult() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.getExpression() instanceof ConstantNode || resultColumn.getExpression() instanceof AggregateNode) continue;
            return false;
        }
        return true;
    }

    public int[] getColumnPositions(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            String string = resultColumn.getName();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)string, (Object)tableDescriptor.getQualifiedName());
            }
            nArray[i] = columnDescriptor.getPosition();
        }
        return nArray;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            stringArray[i] = resultColumn.getName();
        }
        return stringArray;
    }

    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isDefaultColumn()) continue;
            if (!bl) {
                throw StandardException.newException("42Y85");
            }
            ColumnDescriptor columnDescriptor = null;
            if (resultColumnList == null) {
                columnDescriptor = tableDescriptor.getColumnDescriptor(i + 1);
            } else if (i < resultColumnList.size()) {
                object = (ResultColumn)resultColumnList.elementAt(i);
                columnDescriptor = tableDescriptor.getColumnDescriptor(((ResultColumn)object).getName());
            }
            if (columnDescriptor == null) {
                throw StandardException.newException("42X06", tableDescriptor.getQualifiedName());
            }
            if (columnDescriptor.isAutoincrement()) {
                resultColumn.setAutoincrementGenerated();
            }
            if ((object = (DefaultInfoImpl)columnDescriptor.getDefaultInfo()) != null && !((DefaultInfoImpl)object).isGeneratedColumn()) {
                DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(this.getDataDictionary());
                this.getCompilerContext().createDependency(defaultDescriptor);
                resultColumn.setExpression(DefaultNode.parseDefault(((DefaultInfoImpl)object).getDefaultText(), this.getLanguageConnectionContext(), this.getCompilerContext()));
            } else {
                resultColumn.setExpression((ValueNode)this.getNodeFactory().getNode(13, this.getContextManager()));
                resultColumn.setWasDefaultColumn(true);
            }
            resultColumn.setDefaultColumn(false);
        }
    }

    void checkForInvalidDefaults() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.isAutoincrementGenerated() || !resultColumn.isDefaultColumn()) continue;
            throw StandardException.newException("42Y85");
        }
    }

    void verifyAllOrderable() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            resultColumn.verifyOrderable();
        }
    }

    public void populate(TableDescriptor tableDescriptor, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        TableName tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            String string = tableDescriptor.getColumnDescriptor(n2).getColumnName();
            ResultColumn resultColumn = this.makeColumnFromName(string);
            this.addResultColumn(resultColumn);
        }
    }

    private ResultColumn makeColumnFromName(String string) throws StandardException {
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, null, this.getContextManager());
        return resultColumn;
    }

    private ResultColumn makeColumnReferenceFromName(TableName tableName, String string) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, string, nodeFactory.getNode(62, string, tableName, contextManager), contextManager);
        return resultColumn;
    }

    public void forbidOverrides(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            ResultColumn resultColumn2 = (ResultColumn)(resultColumnList == null ? null : resultColumnList.elementAt(i));
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            if (columnDescriptor != null && columnDescriptor.hasGenerationClause()) {
                if (resultColumn2 != null && !resultColumn2.hasGenerationClause() && !resultColumn2.wasDefaultColumn()) {
                    throw StandardException.newException("42XA3", resultColumn.getName());
                }
                if (resultColumn2 != null) {
                    resultColumn2.setColumnDescriptor(columnDescriptor.getTableDescriptor(), columnDescriptor);
                }
            }
            if (columnDescriptor == null || !columnDescriptor.isAutoincrement()) continue;
            if (resultColumn2 != null && resultColumn2.isAutoincrementGenerated()) {
                resultColumn2.setColumnDescriptor(columnDescriptor.getTableDescriptor(), columnDescriptor);
                continue;
            }
            if (!columnDescriptor.isAutoincAlways()) continue;
            throw StandardException.newException("42Z23", resultColumn.getName());
        }
    }

    public void incOrderBySelect() {
        ++this.orderBySelect;
    }

    private void decOrderBySelect() {
        --this.orderBySelect;
    }

    public int getOrderBySelect() {
        return this.orderBySelect;
    }

    public void copyOrderBySelect(ResultColumnList resultColumnList) {
        this.orderBySelect = resultColumnList.orderBySelect;
    }

    protected void markInitialSize() {
        this.initialListSize = this.size();
    }

    private int numGeneratedColumns() {
        int n = 0;
        int n2 = this.size();
        boolean bl = false;
        for (int i = n2 - 1; i >= 0; --i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (resultColumn.isGenerated()) {
                ++n;
                continue;
            }
            bl = true;
        }
        return n;
    }

    int numGeneratedColumnsForGroupBy() {
        int n = 0;
        int n2 = this.size();
        for (int i = n2 - 1; i >= 0; --i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isGenerated() || !resultColumn.isGroupingColumn()) continue;
            ++n;
        }
        return n;
    }

    void removeGeneratedGroupingColumns() {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(i);
            if (!resultColumn.isGenerated() || !resultColumn.isGroupingColumn()) continue;
            this.removeElementAt(i);
        }
    }

    public int visibleSize() {
        return this.size() - this.orderBySelect - this.numGeneratedColumns();
    }

    public String toString() {
        return "";
    }

    private static boolean streamableType(ResultColumn resultColumn) {
        DataTypeDescriptor dataTypeDescriptor = resultColumn.getType();
        TypeId typeId = TypeId.getBuiltInTypeId(dataTypeDescriptor.getTypeName());
        if (typeId != null) {
            return typeId.streamStorable();
        }
        return false;
    }

    private static void updateArrays(int[] nArray, boolean[] blArray, Map map, ResultColumn resultColumn, int n) {
        int n2;
        nArray[n] = n2 = resultColumn.getVirtualColumnId();
        if (ResultColumnList.streamableType(resultColumn)) {
            Integer n3 = (Integer)map.get(new Integer(n2));
            if (n3 != null) {
                blArray[n] = true;
            } else {
                map.put(new Integer(n2), new Integer(n));
            }
        }
    }

    public class ColumnMapping {
        public final int[] mapArray;
        public final boolean[] cloneMap;

        public ColumnMapping(int[] nArray, boolean[] blArray) {
            this.mapArray = nArray;
            this.cloneMap = blArray;
        }
    }
}

