/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

final class StorageFactoryService
implements PersistentService {
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String string, Class clazz) throws StandardException {
        this.subSubProtocol = string;
        this.storageFactoryClass = clazz;
        Object object = Monitor.getMonitor().getEnvironment();
        if (object instanceof File) {
            final File file = (File)object;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, StandardException {
                        StorageFactoryService.this.home = file.getPath();
                        StorageFactoryService.this.canonicalHome = file.getCanonicalPath();
                        StorageFactoryService.this.rootStorageFactory = StorageFactoryService.this.getStorageFactoryInstance(true, null, null, null);
                        if (StorageFactoryService.this.home != null) {
                            StorageFile storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                            storageFile.mkdirs();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException iOException) {
                throw Monitor.exceptionStartingModule(iOException);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StorageFactoryService.this.separatorChar = StorageFactoryService.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    public boolean hasStorageFactory() {
        return true;
    }

    public StorageFactory getStorageFactoryInstance(final boolean bl, final String string, final String string2, final String string3) throws StandardException, IOException {
        try {
            return (StorageFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException, IOException {
                    return StorageFactoryService.this.privGetStorageFactoryInstance(bl, string, string2, string3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw StandardException.newException("XBM0W.S", exception, (Object)this.subSubProtocol, (Object)this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean bl, String string, String string2, String string3) throws InstantiationException, IllegalAccessException, IOException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.newInstance();
        String string4 = string != null && this.subSubProtocol != null && string.startsWith(this.subSubProtocol + ":") ? string.substring(this.subSubProtocol.length() + 1) : string;
        storageFactory.init(bl ? this.home : null, string4, string2, string3);
        return storageFactory;
    }

    public String getType() {
        return this.subSubProtocol;
    }

    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    public Properties getServiceProperties(final String string, Properties properties) throws StandardException {
        final String string2 = this.recreateServiceRoot(string, properties);
        final Properties properties2 = new Properties(properties);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    block7: {
                        if (string2 != null) {
                            File file = new File(string2, "service.properties");
                            FileInputStream fileInputStream = new FileInputStream(file);
                            try {
                                properties2.load(new BufferedInputStream(fileInputStream));
                                Object var4_5 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                ((InputStream)fileInputStream).close();
                                throw throwable;
                            }
                            ((InputStream)fileInputStream).close();
                            {
                                break block7;
                            }
                        }
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                        StorageFile storageFile = storageFactory.newStorageFile("service.properties");
                        try {
                            InputStream inputStream = storageFile.getInputStream();
                            try {
                                properties2.load(new BufferedInputStream(inputStream));
                                Object var6_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                inputStream.close();
                                throw throwable;
                            }
                            inputStream.close();
                            Object var8_12 = null;
                            storageFactory.shutdown();
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            storageFactory.shutdown();
                            throw throwable;
                        }
                    }
                    return null;
                }
            });
            return properties2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                return null;
            }
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
        catch (SecurityException securityException) {
            throw Monitor.exceptionStartingModule(securityException);
        }
    }

    public void saveServiceProperties(final String string, StorageFactory storageFactory, final Properties properties, final boolean bl) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D");
        }
        final WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    StorageFile storageFile = null;
                    StorageFile storageFile2 = writableStorageFactory.newStorageFile("service.properties");
                    if (bl) {
                        storageFile = writableStorageFactory.newStorageFile("service.properties".concat("old"));
                        try {
                            if (!storageFile2.renameTo(storageFile)) {
                                throw StandardException.newException("XBM0S.D", (Object)storageFile2, (Object)storageFile);
                            }
                        }
                        catch (SecurityException securityException) {
                            throw Monitor.exceptionStartingModule(securityException);
                        }
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = storageFile2.getOutputStream();
                        properties.store(outputStream, string + MessageService.getTextMessage("M001"));
                        writableStorageFactory.sync(outputStream, false);
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            outputStream = null;
                        }
                        if (storageFile != null) {
                            try {
                                storageFile2.delete();
                                storageFile.renameTo(storageFile2);
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    if (storageFile != null) {
                        try {
                            storageFile.delete();
                            storageFile = null;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    public void saveServiceProperties(final String string, final Properties properties, final boolean bl) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                File backupFile = null;

                public Object run() throws StandardException {
                    File file = new File(string, "service.properties");
                    if (bl) {
                        this.backupFile = new File(string, "service.properties".concat("old"));
                        try {
                            if (!file.renameTo(this.backupFile)) {
                                throw StandardException.newException("XBM0S.D", (Object)file, (Object)this.backupFile);
                            }
                        }
                        catch (SecurityException securityException) {
                            throw Monitor.exceptionStartingModule(securityException);
                        }
                    }
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        properties.store(fileOutputStream, string + MessageService.getTextMessage("M001"));
                        fileOutputStream.getFD().sync();
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            fileOutputStream = null;
                        }
                        if (this.backupFile != null) {
                            try {
                                file.delete();
                                this.backupFile.renameTo(file);
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    if (this.backupFile != null) {
                        try {
                            this.backupFile.delete();
                            this.backupFile = null;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String string, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = properties.getProperty("createFrom");
        if (string2 != null) {
            bl = true;
            bl2 = false;
        } else {
            string2 = properties.getProperty("restoreFrom");
            if (string2 != null) {
                bl = true;
                bl2 = true;
            } else {
                string2 = properties.getProperty("rollForwardRecoveryFrom");
                if (string2 != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                                StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                                try {
                                    StorageFile storageFile = storageFactory.newStorageFile(null);
                                    7 var3_3 = storageFile.exists() ? this : null;
                                    Object var5_4 = null;
                                    storageFactory.shutdown();
                                    return var3_3;
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    storageFactory.shutdown();
                                    throw throwable;
                                }
                            }
                        }) == null) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
                    }
                }
            }
        }
        if (string2 == null) return string2;
        File file = new File(string2);
        if (!this.fileExists(file)) throw StandardException.newException("XBM0Y.D", file);
        File file2 = new File(string2, "service.properties");
        if (!this.fileExists(file2)) throw StandardException.newException("XBM0Q.D", file2);
        if (bl) {
            this.createServiceRoot(string, bl2);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    Object var3_3;
                    WritableStorageFactory writableStorageFactory = (WritableStorageFactory)StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = writableStorageFactory.newStorageFile("service.properties");
                        if (storageFile.exists() && !storageFile.delete()) {
                            throw StandardException.newException("XBM0R.D", storageFile);
                        }
                        var3_3 = null;
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        writableStorageFactory.shutdown();
                        throw throwable;
                    }
                    writableStorageFactory.shutdown();
                    return var3_3;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!bl) return string2;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return string2;
    }

    public String createServiceRoot(final String string, final boolean bl) throws StandardException {
        Exception exception;
        block4: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D");
            }
            exception = null;
            try {
                return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                        String string3;
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                        StorageFile storageFile = storageFactory.newStorageFile(null);
                        if (storageFile.exists()) {
                            if (bl) {
                                if (!storageFile.deleteAll()) {
                                    throw StandardException.newException("XBM0I.D", StorageFactoryService.this.getDirectoryPath(string));
                                }
                            } else {
                                StorageFactoryService.this.vetService(storageFactory, string);
                                throw StandardException.newException("XBM0J.D", StorageFactoryService.this.getDirectoryPath(string));
                            }
                        }
                        if (!storageFile.mkdirs()) throw StandardException.newException("XBM0H.D", storageFile);
                        String string2 = storageFile.getCanonicalPath();
                        storageFactory.setCanonicalName(string2);
                        try {
                            string3 = storageFactory.getCanonicalName();
                        }
                        catch (IOException iOException) {
                            try {
                                storageFile.deleteAll();
                                throw iOException;
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                storageFactory.shutdown();
                                throw throwable;
                            }
                        }
                        Object var6_6 = null;
                        storageFactory.shutdown();
                        return string3;
                    }
                });
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (PrivilegedActionException privilegedActionException) {
                exception = privilegedActionException.getException();
                if (!(exception instanceof StandardException)) break block4;
                throw (StandardException)exception;
            }
        }
        throw StandardException.newException("XBM0H.D", exception, (Object)string);
    }

    private void vetService(StorageFactory storageFactory, String string) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties");
        if (!storageFile2.exists() && (storageFile = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException("XBM0A.D", (Object)string, (Object)"service.properties");
        }
    }

    private String getDirectoryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.home != null) {
            stringBuffer.append(this.home);
            stringBuffer.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            stringBuffer.append(string.replace('/', this.separatorChar));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean removeServiceRoot(final String string) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = storageFactory.newStorageFile(null);
                        10 var3_3 = storageFile.deleteAll() ? this : null;
                        Object var5_4 = null;
                        storageFactory.shutdown();
                        return var3_3;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        storageFactory.shutdown();
                        throw throwable;
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    public String getCanonicalServiceName(String string) throws StandardException {
        int n = string.indexOf(58);
        if (n < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (n > 1) {
            if (!string.startsWith(this.getType() + ":")) {
                return null;
            }
            string = string.substring(n + 1);
        }
        final String string2 = string;
        try {
            return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                    try {
                        String string = storageFactory.getCanonicalName();
                        Object var4_3 = null;
                        storageFactory.shutdown();
                        return string;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        storageFactory.shutdown();
                        throw throwable;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
    }

    public String getUserServiceName(String string) {
        if (this.home != null && string.length() > this.canonicalHome.length() + 1 && string.startsWith(this.canonicalHome) && (string = string.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            string = string.substring(1);
        }
        return string.replace(this.separatorChar, '/');
    }

    public boolean isSameService(String string, String string2) {
        return string.equals(string2);
    }

    private final boolean fileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    final class DirectoryList
    implements Enumeration,
    PrivilegedAction {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        public final Object run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile storageFile;
                            String string = this.contents[this.index];
                            StorageFile storageFile2 = StorageFactoryService.this.rootStorageFactory.newStorageFile(string);
                            if (storageFile2.isDirectory() && (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(storageFile2, "service.properties")).exists()) {
                                this.contents[this.index] = storageFile2.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

