/**
 * WindowsSetupHelpFrame.java
 *
 * Copyright (C) 2010 imedias
 *
 * This file is part of JBackpack.
 *
 * JBackpack is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * JBackpack is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Created on 30.06.2010, 16:54:42
 */
package ch.fhnw.jbackpack;

import ch.fhnw.util.FileTools;
import ch.fhnw.util.FileTransferable;
import ch.fhnw.util.ProcessExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/**
 * A frame for helping Windows users install rdiff-backup
 *
 * @author Ronny Standtke <ronny.standtke@fhnw.ch>
 */
public class WindowsSetupHelpFrame extends javax.swing.JFrame {

    private final static Logger LOGGER =
            Logger.getLogger(WindowsSetupHelpFrame.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(
            "ch/fhnw/jbackpack/Strings");
    private final static File HOME_DIR =
            new File(System.getProperty("user.home"));

    /**
     * Creates new form WindowsSetupHelpFrame
     */
    public WindowsSetupHelpFrame() {
        initComponents();
        pack();
        setLocationRelativeTo(null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        errorlabel = new javax.swing.JLabel();
        adminRightsLabel = new javax.swing.JLabel();
        installRdiffbackupButton = new javax.swing.JButton();
        msLabel = new javax.swing.JLabel();
        installMSButton = new javax.swing.JButton();
        buttonPanel = new javax.swing.JPanel();
        restartButton = new javax.swing.JButton();
        exitButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings"); // NOI18N
        setTitle(bundle.getString("WindowsSetupHelpFrame.title")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        errorlabel.setIcon(IconManager.ERROR_ICON);
        errorlabel.setText(bundle.getString("WindowsSetupHelpDialog.errorlabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        getContentPane().add(errorlabel, gridBagConstraints);

        adminRightsLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        adminRightsLabel.setText(bundle.getString("WindowsSetupHelpFrame.adminRightsLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        getContentPane().add(adminRightsLabel, gridBagConstraints);

        installRdiffbackupButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/download_manager.png"))); // NOI18N
        installRdiffbackupButton.setText(bundle.getString("WindowsSetupHelpDialog.installRdiffbackupButton.text")); // NOI18N
        installRdiffbackupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                installRdiffbackupButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 0, 10);
        getContentPane().add(installRdiffbackupButton, gridBagConstraints);

        msLabel.setText(bundle.getString("WindowsSetupHelpDialog.msLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 0, 15);
        getContentPane().add(msLabel, gridBagConstraints);

        installMSButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/download_manager.png"))); // NOI18N
        installMSButton.setText(bundle.getString("WindowsSetupHelpDialog.installMSButton.text")); // NOI18N
        installMSButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                installMSButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 0, 10);
        getContentPane().add(installMSButton, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        restartButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/reload.png"))); // NOI18N
        restartButton.setText(bundle.getString("WindowsSetupHelpDialog.restartButton.text")); // NOI18N
        restartButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                restartButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 5);
        buttonPanel.add(restartButton, gridBagConstraints);

        exitButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/exit.png"))); // NOI18N
        exitButton.setText(bundle.getString("WindowsSetupHelpDialog.exitButton.text")); // NOI18N
        exitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 10, 0);
        buttonPanel.add(exitButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void installMSButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installMSButtonActionPerformed

        final File exeFile = new File(HOME_DIR, "vcredist_x86.exe");
        LOGGER.log(Level.INFO, "downloading to {0}", exeFile);
        try {
            // save exe locally
            URL url = new URL("http://download.microsoft.com/download/"
                    + "d/d/9/dd9a82d0-52ef-40db-8dab-795376989c03/"
                    + "vcredist_x86.exe");

            final DownloadSwingWorker downloadSwingWorker =
                    new DownloadSwingWorker(this, url,
                    "Microsoft Visual C++ 2008 Redistributable Package",
                    exeFile);
            downloadSwingWorker.execute();

            new Thread() {

                @Override
                public void run() {
                    try {
                        if (downloadSwingWorker.get()) {
                            ProcessExecutor processExecutor =
                                    new ProcessExecutor();
                            processExecutor.executeProcess(exeFile.getPath());
                        }
                    } catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    } catch (ExecutionException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }.start();

        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
}//GEN-LAST:event_installMSButtonActionPerformed

    private void installRdiffbackupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installRdiffbackupButtonActionPerformed
        final File win32File =
                new File(HOME_DIR, "rdiff-backup-1.2.8-win32.zip");
        LOGGER.log(Level.INFO, "downloading to {0}", win32File);
        final String description = "rdiff-backup";
        try {
            // save zip locally
            URL url = new URL("http://savannah.nongnu.org/download/"
                    + "rdiff-backup/rdiff-backup-1.2.8-win32.zip");

            final DownloadSwingWorker downloadSwingWorker =
                    new DownloadSwingWorker(
                    this, url, description, win32File);
            downloadSwingWorker.execute();

            new Thread() {

                @Override
                public void run() {
                    try {
                        if (downloadSwingWorker.get()) {
                            unpackAndCopy(win32File, description);
                        } else {
                            String errorMessage =
                                    BUNDLE.getString("Downloading_Failed");
                            errorMessage = MessageFormat.format(
                                    errorMessage, description,
                                    downloadSwingWorker.getIoException());
                            JOptionPane.showMessageDialog(
                                    WindowsSetupHelpFrame.this, errorMessage,
                                    BUNDLE.getString("Error"),
                                    JOptionPane.ERROR_MESSAGE);
                        }
                    } catch (InterruptedException ex) {
                        rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    } catch (ExecutionException ex) {
                        rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    } catch (IOException ex) {
                        rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }.start();

        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
}//GEN-LAST:event_installRdiffbackupButtonActionPerformed

    private void restartButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_restartButtonActionPerformed
        setVisible(false);
        dispose();
        JBackpack.systemCheck();
}//GEN-LAST:event_restartButtonActionPerformed

    private void exitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed
        System.exit(-1);
}//GEN-LAST:event_exitButtonActionPerformed

    private void unpackAndCopy(File win32File, String description)
            throws IOException {
        String osName = System.getProperty("os.name");
        String system32Path = "C:\\Windows\\System32";
        if ("Windows XP".equals(osName)) {
            // we can directly unzip rdiff-backup.exe to the destination
            unpack(win32File, new File(system32Path));
            String infoMessage = BUNDLE.getString("Installation_Finished");
            infoMessage = MessageFormat.format(infoMessage, description);
            JOptionPane.showMessageDialog(this, infoMessage,
                    BUNDLE.getString("Information"),
                    JOptionPane.INFORMATION_MESSAGE);

        } else {
            // UAC is in our way, all we can do is to unpack rdiff-backup.exe
            // into a temporary directory
            File tempDir = FileTools.createTempDirectory("jbackpack", null);
            unpack(win32File, tempDir);
            File tempFile = new File(tempDir, "rdiff-backup.exe");
            FileTransferable.copy(tempFile);

            // show info dialog
            JOptionPane.showMessageDialog(this,
                    BUNDLE.getString("Windows_Manual_Copy_Info"),
                    BUNDLE.getString("Information"),
                    JOptionPane.INFORMATION_MESSAGE);

            // open Explorer window and let the user copy the file manually...

            // desktop.browse() did not work on lenovo netbook!?
//            Desktop desktop = Desktop.getDesktop();
//            desktop.browse(system32Dir.toURI());
            ProcessExecutor processExecutor = new ProcessExecutor();
            processExecutor.executeProcess("explorer.exe", system32Path);

        }
    }

    private void unpack(File win32File, File destinationDir)
            throws IOException {
        ZipFile zipFile = new ZipFile(win32File);
        ZipEntry entry = zipFile.getEntry(
                "rdiff-backup-1.2.8/rdiff-backup.exe");
        InputStream inputStream = zipFile.getInputStream(entry);
        File target = new File(destinationDir, "rdiff-backup.exe");
        FileOutputStream fileOutputStream = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        for (int count = inputStream.read(buffer); count != -1;) {
            fileOutputStream.write(buffer, 0, count);
            count = inputStream.read(buffer);
        }
        inputStream.close();
        fileOutputStream.close();
    }

    private void rdiffBackupInstallationFailed() {
        JOptionPane.showMessageDialog(this,
                BUNDLE.getString("RdiffBackup_Installation_Failed"),
                BUNDLE.getString("Error"),
                JOptionPane.ERROR_MESSAGE);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel adminRightsLabel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JLabel errorlabel;
    private javax.swing.JButton exitButton;
    private javax.swing.JButton installMSButton;
    private javax.swing.JButton installRdiffbackupButton;
    private javax.swing.JLabel msLabel;
    private javax.swing.JButton restartButton;
    // End of variables declaration//GEN-END:variables
}
