/**
 * PlaintextBackupWarningDialog.java
 *
 * Copyright (C) 2010 imedias
 *
 * This file is part of JBackpack.
 *
 * JBackpack is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * JBackpack is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Created on 04.07.2010, 14:28:31
 */
package ch.fhnw.jbackpack;

/**
 * A dialog to show when the backup directory is not encrypted
 *
 * @author Ronny Standtke <Ronny.Standtke@gmx.net>
 */
public class PlaintextBackupWarningDialog extends javax.swing.JDialog {

    private boolean okPressed;

    /**
     * Creates new form PlaintextBackupWarningDialog
     *
     * @param parent the parent frame
     */
    public PlaintextBackupWarningDialog(java.awt.Frame parent) {
        super(parent, true);
        initComponents();
        warningLabel.setIcon(IconManager.WARNING_ICON);
        pack();
        setLocationRelativeTo(parent);
    }

    /**
     * returns <tt>true</tt>, if the user pressed the OK button, <tt>false</tt>
     * otherwise
     *
     * @return the okPressed <tt>true</tt>, if the user pressed the OK button,
     * <tt>false</tt> otherwise
     */
    public boolean isOkPressed() {
        return okPressed;
    }

    /**
     * returns <tt>true</tt> if the user selected to continue to show this
     * warning dialog, <tt>false</tt> otherwise
     *
     * @return <tt>true</tt> if the user selected to continue to show this
     * warning dialog, <tt>false</tt> otherwise
     */
    public boolean isShowWarningSelected() {
        return showWarningCheckBox.isSelected();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        warningLabel = new javax.swing.JLabel();
        yesButton = new javax.swing.JButton();
        noButton = new javax.swing.JButton();
        showWarningCheckBox = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings"); // NOI18N
        setTitle(bundle.getString("PlaintextBackupWarningDialog.title")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        warningLabel.setText(bundle.getString("PlaintextBackupWarningDialog.warningLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(warningLabel, gridBagConstraints);

        yesButton.setText(bundle.getString("PlaintextBackupWarningDialog.yesButton.text")); // NOI18N
        yesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                yesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 5);
        getContentPane().add(yesButton, gridBagConstraints);

        noButton.setText(bundle.getString("PlaintextBackupWarningDialog.noButton.text")); // NOI18N
        noButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 0, 0);
        getContentPane().add(noButton, gridBagConstraints);

        showWarningCheckBox.setSelected(true);
        showWarningCheckBox.setText(bundle.getString("PlaintextBackupWarningDialog.showWarningCheckBox.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 10);
        getContentPane().add(showWarningCheckBox, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void yesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yesButtonActionPerformed
        okPressed = true;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_yesButtonActionPerformed

    private void noButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noButtonActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_noButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton noButton;
    private javax.swing.JCheckBox showWarningCheckBox;
    private javax.swing.JLabel warningLabel;
    private javax.swing.JButton yesButton;
    // End of variables declaration//GEN-END:variables
}
