/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import net.sourceforge.jnlp.cache.CacheDirectory;
import net.sourceforge.jnlp.cache.DirectoryNode;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;

public class CachePane
extends JPanel {
    JDialog parent;
    DeploymentConfiguration config;
    private String location;
    private JComponent defaultFocusComponent;
    DirectoryNode root;
    String[] columns = new String[]{Translator.R("CVCPColName"), Translator.R("CVCPColPath"), Translator.R("CVCPColType"), Translator.R("CVCPColDomain"), Translator.R("CVCPColSize"), Translator.R("CVCPColLastModified")};
    JTable cacheTable;

    public CachePane(JDialog parent, DeploymentConfiguration config) {
        super(new BorderLayout());
        this.parent = parent;
        this.config = config;
        this.location = config.getProperty("deployment.user.cachedir");
        this.addComponents();
    }

    private void addComponents() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        DefaultTableModel model = new DefaultTableModel(this.columns, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.cacheTable = new JTable(model);
        this.cacheTable.getSelectionModel().setSelectionMode(0);
        this.cacheTable.setAutoResizeMode(1);
        this.cacheTable.setPreferredScrollableViewportSize(new Dimension(600, 200));
        this.cacheTable.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.cacheTable);
        this.populateTable();
        TableRowSorter<1> tableSorter = new TableRowSorter<1>(model);
        tableSorter.setComparator(4, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o1.compareTo(o2);
            }
        });
        tableSorter.setComparator(5, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
                try {
                    Long time1 = format.parse(o1).getTime();
                    Long time2 = format.parse(o2).getTime();
                    return time1.compareTo(time2);
                }
                catch (ParseException e) {
                    return 0;
                }
            }
        });
        this.cacheTable.setRowSorter(tableSorter);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        topPanel.add((Component)scrollPane, c);
        this.add((Component)topPanel, "Center");
        this.add(this.createButtonPanel(), "South");
    }

    private Component createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        JPanel leftPanel = new JPanel(new FlowLayout(3));
        JPanel rightPanel = new JPanel(new FlowLayout(4));
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JButton deleteButton = new JButton(Translator.R("CVCPButDelete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLock fl = null;
                File netxRunningFile = new File(CachePane.this.config.getProperty("deployment.user.runningfile"));
                if (!netxRunningFile.exists()) {
                    try {
                        FileUtils.createParentDir(netxRunningFile);
                        FileUtils.createRestrictedFile(netxRunningFile, true);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    fl = FileUtils.getFileLock(netxRunningFile.getPath(), false, false);
                }
                catch (FileNotFoundException e1) {
                    // empty catch block
                }
                int row = CachePane.this.cacheTable.getSelectedRow();
                try {
                    if (fl == null) {
                        return;
                    }
                    if (row == -1 || row > CachePane.this.cacheTable.getRowCount() - 1) {
                        return;
                    }
                    int modelRow = CachePane.this.cacheTable.convertRowIndexToModel(row);
                    DirectoryNode fileNode = (DirectoryNode)CachePane.this.cacheTable.getModel().getValueAt(modelRow, 0);
                    if (fileNode.getFile().delete()) {
                        this.updateRecentlyUsed(fileNode.getFile());
                        fileNode.getParent().removeChild(fileNode);
                        FileUtils.deleteWithErrMesg(fileNode.getInfoFile());
                        ((DefaultTableModel)CachePane.this.cacheTable.getModel()).removeRow(modelRow);
                        CachePane.this.cacheTable.getSelectionModel().setSelectionInterval(row, row);
                        CacheDirectory.cleanParent(fileNode);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fl != null) {
                    try {
                        fl.release();
                        fl.channel().close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }

            private void updateRecentlyUsed(File f) {
                File recentlyUsedFile = new File(CachePane.this.location + File.separator + "recently_used");
                PropertiesFile pf = new PropertiesFile(recentlyUsedFile);
                pf.load();
                Enumeration<Object> en = pf.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!pf.get(key).equals(f.getAbsolutePath())) continue;
                    pf.remove(key);
                }
                pf.store();
            }
        });
        buttons.add(deleteButton);
        JButton refreshButton = new JButton(Translator.R("CVCPButRefresh"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachePane.this.populateTable();
            }
        });
        buttons.add(refreshButton);
        JButton doneButton = new JButton(Translator.R("ButDone"));
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachePane.this.parent.dispose();
            }
        });
        int maxWidth = 0;
        int maxHeight = 0;
        for (JButton button : buttons) {
            maxWidth = Math.max(button.getMinimumSize().width, maxWidth);
            maxHeight = Math.max(button.getMinimumSize().height, maxHeight);
        }
        int wantedWidth = maxWidth + 10;
        int wantedHeight = maxHeight;
        for (JButton button : buttons) {
            button.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
            leftPanel.add(button);
        }
        doneButton.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
        rightPanel.add(doneButton);
        buttonPanel.add(leftPanel);
        buttonPanel.add(rightPanel);
        return buttonPanel;
    }

    private void populateTable() {
        ((DefaultTableModel)this.cacheTable.getModel()).setRowCount(0);
        for (Object[] v : this.generateData(this.root)) {
            ((DefaultTableModel)this.cacheTable.getModel()).addRow(v);
        }
    }

    private ArrayList<Object[]> generateData(DirectoryNode root) {
        root = new DirectoryNode("Root", this.location, null);
        CacheDirectory.getDirStructure(root);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (DirectoryNode identifier : root.getChildren()) {
            for (DirectoryNode type : identifier.getChildren()) {
                for (DirectoryNode domain : type.getChildren()) {
                    for (DirectoryNode leaf : CacheDirectory.getLeafData(domain)) {
                        Object[] o = new Object[]{leaf, leaf.getFile().getAbsolutePath(), type, domain, leaf.getFile().length(), new SimpleDateFormat("MM/dd/yyyy").format(leaf.getFile().lastModified())};
                        data.add(o);
                    }
                }
            }
        }
        return data;
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }
}

