/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.util;

import ch.fhnw.util.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class DirSizeCalculator {
    private boolean run = true;
    private final AtomicLong size = new AtomicLong();
    private final AtomicLong fileCounter = new AtomicLong();
    private File currentFile;

    public void calculateSize(File file) throws IOException {
        if (!this.run) {
            return;
        }
        this.fileCounter.incrementAndGet();
        this.currentFile = file;
        if (FileTools.isSymlink(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.calculateSize(subFile);
            }
        } else {
            this.size.addAndGet(file.length());
        }
    }

    public long getCurrentSize() {
        return this.size.get();
    }

    public long getFileCounter() {
        return this.fileCounter.get();
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void stop() {
        this.run = false;
    }

    public void reset() {
        this.run = true;
        this.size.set(0L);
    }
}

