/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.jbackpack.chooser.RdiffFileDatabase;
import ch.fhnw.jbackpack.chooser.RdiffTimestamp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Increment {
    private static final Logger LOGGER = Logger.getLogger(Increment.class.getName());
    private final Increment youngerIncrement;
    private final File backupDirectory;
    private final RdiffTimestamp timestamp;
    private final RdiffFile rdiffRoot;
    private Long size;

    public Increment(Increment youngerIncrement, RdiffTimestamp timestamp, RdiffFileDatabase rdiffFileDatabase, File backupDirectory) {
        this.youngerIncrement = youngerIncrement;
        this.timestamp = timestamp;
        this.backupDirectory = backupDirectory;
        this.size = youngerIncrement == null ? Long.valueOf(Math.max(0L, this.getSessionStatisticsValue("SourceFileSize"))) : Long.valueOf(Math.max(0L, youngerIncrement.getSessionStatisticsValue("IncrementFileSize")));
        this.rdiffRoot = new RdiffFile(rdiffFileDatabase, this, null, ".", 0L, 0L, true);
    }

    public boolean isMirror() {
        return this.youngerIncrement == null;
    }

    public Increment getYoungerIncrement() {
        return this.youngerIncrement;
    }

    public Date getTimestamp() {
        return this.timestamp.getTimestamp();
    }

    public String getRdiffTimestamp() {
        return String.valueOf(this.timestamp.getTimestamp().getTime() / 1000L);
    }

    public Long getSize() {
        return this.size;
    }

    public RdiffFile getRdiffRoot() {
        return this.rdiffRoot;
    }

    public File getBackupDirectory() {
        return this.backupDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSessionStatisticsValue(String key) {
        File statisticsFile = Increment.getRdiffBackupFile(this.backupDirectory.getPath(), "session_statistics." + this.timestamp.getFilestamp());
        if (statisticsFile == null) {
            return 0L;
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileReader = new FileReader(statisticsFile);
            bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith(key)) continue;
                String[] tokens = line.split(" ");
                if (tokens.length > 1) {
                    try {
                        long l = Long.parseLong(tokens[1]);
                        return l;
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                        continue;
                    }
                }
                LOGGER.log(Level.WARNING, "could not parse line:\n{0}", line);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "could not load increment size", ex);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
        return 0L;
    }

    public static File getRdiffBackupFile(String backupDirectory, final String prefix) {
        File rdiffBackupDataDirectory = new File(backupDirectory + File.separatorChar + "rdiff-backup-data");
        File[] metaFiles = rdiffBackupDataDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        });
        if (metaFiles == null || metaFiles.length == 0) {
            LOGGER.log(Level.WARNING, "No file with prefix {0} found", prefix);
            return null;
        }
        if (metaFiles.length != 1) {
            LOGGER.log(Level.WARNING, "Several files with prefix {0} found", prefix);
        }
        return metaFiles[0];
    }
}

