/* Copyright 2005 by Stefan Thesing
 <p>This program is free software; you can 
 redistribute it and/or modify it under the terms 
 of the GNU General Public License as published by 
 the Free Software Foundation; either version 2 of 
 the License, or (at your option) any later version.</p>
 <p>This program is distributed in the hope that it 
 will be useful, but WITHOUT ANY WARRANTY; without 
 even the implied warranty of MERCHANTABILITY or 
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 General Public License for more details.</p>
 <p>You should have received a copy of the GNU 
 General Public License along with this program; 
 if not, write to the <br>
 Free Software Foundation, Inc.,<br>
 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.<br>
 */
package de.webdings.tools;

/**
 * StringSearch offers some basic search functions with Strings.
 * 
 * @author Copyright 2005 by Stefan Thesing<br>
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0 Created on 23.05.2005
 */
public class StringSearch {
    /**
     * Returns <code>true</code> if <code>s</code> contains 
     * <code>search</code> as a substring. StringSearch 
     * is not case sensitive.
     * 
     * @param s String that is searched
     * @param search String that is searched for
     * @return <code>true</code> if <code>s</code> contains <code>search</code>
     */
    public static boolean stringContains(String s, String search) {
		//Case1: search has the same length as s
		if(search.length() == s.length()) {
			return s.equalsIgnoreCase(search);
		}
		//Case2: search is shorter than s.
		//Compare all possible substrings of s that have the same
		//length as search, to search
		if(search.length() < s.length()) {
			String sub;
			for(int i=0; i<=s.length()-search.length(); ++i) {
				sub = s.substring(i, i+search.length());
				if(sub.equalsIgnoreCase(search)){
					return true;
				}
			}
		}
		//Case3: search is longer than s, ergo: s cannot contain search
		return false;
	}
	
	/**
	 * Does the same as {@link #stringContains(String, String) stringContains()},
	 * but it's case sensitive.
	 * @param s String that is searched
     * @param search String that is searched for
     * @return <code>true</code> if <code>s</code> contains <code>search</code>
     */
	public static boolean stringContainsCaseSensitive(String s, String search) {
//		Case1: search has the same length as s
		if(search.length() == s.length()) {
			return s.equals(search);
		}
		//Case2: search is shorter than s.
		//Compare all possible substrings of s that have the same
		//length as search, to search
		if(search.length() < s.length()) {
			String sub;
			for(int i=0; i<=s.length()-search.length(); ++i) {
				sub = s.substring(i, i+search.length());
				if(sub.equals(search)){
					return true;
				}
			}
		}
		//Case3: search is longer than s, ergo: s cannot contain search
		return false;
	}
}
