/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "wallet.h"

GHashTable*			                          g_wallet_cache= 0;

extern void
wallet_create_cache()
{

  do
  {

    if (g_wallet_cache)
    {
      break;
    }

    g_wallet_cache= g_hash_table_new_full(
      g_str_hash,
      g_str_equal,
      0,
      (GDestroyNotify)password_free);

  }while(0);

  return;
}

extern void
wallet_destroy_cache()
{

  if (g_wallet_cache)
  {
    g_hash_table_destroy(g_wallet_cache);
  }

  return;
}

extern void
wallet_insert(
  struct password*const                 i_pwd)
{
  g_hash_table_insert(g_wallet_cache, (*i_pwd).m_aspect, i_pwd);
  return;
}

extern struct password*
wallet_lookup(
  char const*                           i_aspect)
{
  struct password*                      l_pwd;

  l_pwd= (struct password*)g_hash_table_lookup(g_wallet_cache, i_aspect);

  return l_pwd;
}
