/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __run_dialog_h__

#include "global_common.h"

struct run_dialog_status
{
  GtkProgressBar*                       m_progressbar;
  GtkLabel*                             m_tuple_label;
  GtkLabel*                             m_report_label;
  size_t                                m_tuple;
  char*                                 m_basename;
  char*                                 m_reportfile;
};

struct run_dialog
{
  GtkDialog*                            m_dialog;
  GtkGrid*                              m_status_grid;
  GtkCheckButton*                       m_open_checkbutton;
  GtkButton*                            m_cancel_button;
  gboolean                              m_cancel;
  struct run_dialog_status*             m_status;
  size_t                                m_status_slots;
  size_t                                m_status_active;
};

extern struct run_dialog                g_run_dialog;

extern void
run_dialog_deinitialize_instance();

extern gboolean
run_dialog_end(
  gpointer                              i_data);

extern gboolean
run_dialog_get_cancelled();

extern GtkDialog*
run_dialog_get_dialog();

extern gboolean
run_dialog_get_instantiated();

extern int
run_dialog_initialize_instance(
  char const*                           i_reportfile);

extern size_t
run_dialog_increment_tuple();

extern void
run_dialog_switch(
  char const*                           i_reportfile);

extern gboolean
run_dialog_update(
  gpointer                              i_data);

#define run_dialog_get_cancelled()\
  (g_run_dialog.m_cancel)

#define run_dialog_get_dialog()\
  g_run_dialog.m_dialog

#define run_dialog_increment_tuple()\
  g_run_dialog.m_dialog ?\
    (++g_run_dialog.m_status[g_run_dialog.m_status_active].m_tuple) : 0

#define run_dialog_get_instantiated()\
  ((gboolean)(ptrdiff_t)g_run_dialog.m_status)

#define __run_dialog_h__
#endif
