/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "query_exec2.h"

static char const*
query_exec2_get_column_value(
  struct query_exec const*const         i_src,
  char const*                           i_column)
{
  struct iwsql_attr const*              l_attr;
  struct query_exec_node const*         l_query;
  unsigned                              l_slot;
  char const*                           l_value;

  l_query= &(*i_src).m_sql[0];
  l_slot= 0;
  l_value= 0;

  do
  {

    if ((*i_src).m_count <= l_slot)
    {
      break;
    }

    query_exec_node_lookup(&l_attr, i_column, l_query);

    if (l_attr)
    {
      l_value= (*l_attr).m_value;
      break;
    }

    l_slot++;
    l_query++;

  }while(1);

  return l_value;
}

static int
query_exec2_set_values(
  GError**                              o_error,
  struct query_exec*const               io_exec,
  struct query_exec const*const         i_data)
{
  GError*                               l_error;
  int                                   l_exit;
  struct sql_node*                      l_node;
  struct query_exec_node*               l_query;
  size_t                                l_size;
  unsigned                              l_slot;
  char const*                           l_value;

  l_error= 0;
  l_exit= 0;
  l_query= &(*io_exec).m_sql[0];
  l_slot= 0;
  l_value= 0;

  do
  {

    if ((*io_exec).m_count <= l_slot)
    {
      break;
    }

    l_node= (*l_query).m_query.m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      do
      {

        if (sql_type_input != (*l_node).m_type)
        {
          break;
        }

        l_value= query_exec2_get_column_value(i_data, (*l_node).m_object.m_input.m_prompt);

        if ((0 == l_value) || (0 == l_value[0]))
        {
          break;
        }

        l_size= strlen(l_value);
        (*l_node).m_object.m_input.m_answer= (char*)g_malloc0(1+l_size);
        memcpy((*l_node).m_object.m_input.m_answer, l_value, l_size);

      }while(0);

      l_node= (*l_node).m_next;

    }while(1);

    l_slot++;
    l_query++;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern int
query_exec2_prepare(
  GError**                              o_error,
  struct query_exec*const               io_exec,
  struct query const*const              i_query,
  struct query_exec const*const         i_data)
{
  GError*                               l_error;
  int                                   l_exit;
  GOutputStream*                        l_gio;
  struct query_exec_node*               l_query;

  l_error= 0;
  l_exit= 0;
  l_gio= 0;

  do
  {

    query_exec_parse(io_exec, i_query);

    l_exit= query_exec2_set_values(&l_error, io_exec, i_data);

    if (l_exit)
    {
      break;
    }

    l_query= &(*io_exec).m_sql[0];

    if (0 == l_query)
    {
      break;
    }

    l_gio= g_memory_output_stream_new_resizable();
    query_exec_write(l_gio, l_query);

    if ((*l_query).m_text)
    {
      g_free((*l_query).m_text);
    }

    g_output_stream_close(l_gio, 0, 0);
    (*l_query).m_text= g_memory_output_stream_steal_data(G_MEMORY_OUTPUT_STREAM(l_gio));
    (*l_query).m_text_size= g_memory_output_stream_get_data_size(G_MEMORY_OUTPUT_STREAM(l_gio));

  }while(0);

  if (l_gio)
  {
    g_object_unref(l_gio);
  }

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}
