/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __query_exec_h__

#include "sql.h"
#include "database_session.h"
#include "global_common.h"
#include "database_aspect.h"

struct query_exec_node
{
  struct sql                            m_query;
  struct database_session               m_session;
  char*                                 m_text;
  size_t                                m_text_size;
  struct iwsql_attr const*              m_attr;
  unsigned                              m_attr_count;
  GHashTable*                           m_hash;
};

struct query_exec
{
  struct query_exec_node*               m_sql;
  unsigned                              m_count;
  GHashTable*                           m_hash;
};

extern void
query_exec_assign(
  struct query_exec*                    o_exec);

extern int
query_exec_connect(
  GError**                              o_error,
  struct query_exec*                    io_exec,
  struct database_aspect const*const    i_aspect);

extern int
query_exec_connect_prepare_first(
  GError**                              o_error,
  int *const                            o_eof,
  struct query_exec*const               io_exec,
  struct query const*const              i_query,
  struct database_aspect const*const    i_aspect,
  GHashTable const*const                i_prompt,
  int const                             i_interactive);

extern void
query_exec_discharge(
  struct query_exec*                    io_exec);

extern void
query_exec_lookup(
  struct query_exec_node const**        o_query,
  char const*                           i_tag,
  struct query_exec const*const         i_exec);

extern int
query_exec_next(
  GError**                              o_error,
  int*const                             o_eof,
  struct query_exec*const               io_exec);

extern void
query_exec_parse(
  struct query_exec*                    io_exec,
  struct query const*const              i_query);

extern int
query_exec_prepare(
  GError**                              o_error,
  struct query_exec*const               io_exec,
  struct query const*const              i_query,
  GHashTable const*const                i_prompt,
  int const                             i_interactive);

extern int
query_exec_run(
  GError**                              o_error,
  struct query_exec*const               io_exec);

extern int
query_exec_write(
  GOutputStream*                        io_gio,
  struct query_exec_node const*const    i_sql);

extern void
query_exec_node_lookup(
  struct iwsql_attr const**             o_attr,
  char const*                           i_tag,
  struct query_exec_node const*const    i_query);

#define query_exec_lookup(o_query, i_tag, i_exec) \
  (*(o_query))= g_hash_table_lookup((*(i_exec)).m_hash, (i_tag))

#define query_exec_node_lookup(o_attr, i_tag, i_query) \
  (*(o_attr))= g_hash_table_lookup((*(i_query)).m_hash, (i_tag))

#define __query_exec_h__
#endif
