/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mainw.h"
#include "password.h"

static int
mainw_run_get_outputfile(
  char**                                o_filename,
  struct mainw *const                   io_mainw)
{
  GtkFileChooser*                       l_chooser;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  char*                                 l_filename;
  GtkFileFilter*                        l_filter;
  char*                                 l_ptr;
  int                                   l_rc;
  unsigned                              l_size;

  (*o_filename)= 0;
  l_exit= 0;
  l_dialog= 0;
  l_filter= 0;
  
  do
  {

    
    l_dialog = gtk_file_chooser_dialog_new(
      "Save Output File",
      (*io_mainw).m_window,
      GTK_FILE_CHOOSER_ACTION_SAVE,
      "_Cancel",
      GTK_RESPONSE_CANCEL,
      "_Save",
      GTK_RESPONSE_ACCEPT,
      NULL);

    l_chooser= GTK_FILE_CHOOSER(l_dialog);
    
    if ((*io_mainw).m_report.m_reportfile)
    {
      l_size= strlen((*io_mainw).m_report.m_reportfile);
      l_filename= (char*)g_malloc0(5+l_size);
      memcpy(l_filename, (*io_mainw).m_report.m_reportfile, l_size);
      l_ptr= strrchr(l_filename, '.');
      if (0 == l_ptr)
      {
        l_ptr= l_filename+l_size;
      }
      switch ((*io_mainw).m_report.m_style)
      {
        case style_label:
          /* fall through */
        case style_layout:
          memcpy(l_ptr, ".pdf\0", 5);
          break;
        case style_export:
          memcpy(l_ptr, ".csv\0", 5);
          break;
        default:
          break;
      } 
      gtk_file_chooser_set_filename(l_chooser, l_filename);
      g_free(l_filename);
      l_filename= 0;
    }
    else
    {
      switch ((*io_mainw).m_report.m_style)
      {
        case style_layout:
          /* fall through */
        case style_label:
          gtk_file_chooser_set_current_name(l_chooser, "report.pdf");
          break;
        case style_export:
          gtk_file_chooser_set_current_name(l_chooser, "report.csv");
          break;
        default:
          break;
      } 
    }

    switch ((*io_mainw).m_report.m_style)
    {
      case style_layout:
      /* fall through */
      case style_label:
        l_filter= gtk_file_filter_new();
        gtk_file_filter_add_pattern(l_filter, "*.pdf");
        gtk_file_filter_set_name(l_filter, "PDF");
        gtk_file_chooser_add_filter(l_chooser, l_filter);
        break;
      case style_export:
        l_filter= gtk_file_filter_new();
        gtk_file_filter_add_pattern(l_filter, "*.csv");
        gtk_file_filter_set_name(l_filter, "CSV");
        gtk_file_chooser_add_filter(l_chooser, l_filter);
        break;
      default:
        break;
    }

    l_rc= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_ACCEPT != l_rc)
    {
      l_exit= -1;
      break;
    }

    (*o_filename)= gtk_file_chooser_get_filename(l_chooser);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy(GTK_WIDGET(l_dialog));
  }

  return l_exit;
}

extern int
mainw_run(
  struct mainw*const                    io_mainw)
{
  GError*                               l_error;
  int                                   l_exit;
  char*                                 l_filename;
  struct goop                           l_goop;

  l_error= 0;
  l_exit= 0;
  l_filename= 0;
  memset(&l_goop, 0, sizeof(l_goop));
  
  do
  {

    l_exit= mainw_save(io_mainw);

    if (l_exit)
    {
      break;
    }

    l_exit= mainw_run_get_outputfile(&l_filename, io_mainw); 

    if (l_exit)
    {
      break;
    }

    l_goop.m_interactive= 1;
    l_goop.m_reportfile= (*io_mainw).m_report.m_reportfile;
    l_goop.m_outputfile= l_filename;

    l_exit= report_util_run(&l_error, &l_goop);

    if (l_exit)
    {
      break;
    }

    mainw_xdg_open_file(l_filename);

  }while(0);

  if (l_filename)
  {
    g_free(l_filename);
  }

  if (l_error)
  {
    _error_display_prompt(l_error); 
    g_clear_error(&l_error);
  }

  return l_exit;
}
