/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __layout_util_h__

#include "layout_spec.h"
#include "rw.h"

extern void
layout_util_break_check(
  struct rw*const                       io_rw,
  struct layout_spec *const             io_layout);

extern void
layout_util_break_check_group(
  struct rw*const                       io_rw,
  struct layout_spec *const             io_layout,
  int const                             i_in_page_break);

extern void
layout_util_break_check_page(
  int*                                  o_break,
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw);

extern void
layout_util_draw_division(
  struct layout_spec_division*const     io_division,
  struct rw*const                       io_rw);

extern void
layout_util_draw_footer(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw);

extern void
layout_util_draw_group_footer(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw);

extern void
layout_util_draw_headers(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw);

#define __layout_util_h__
#endif
