/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "layout_util.h"
#include "layout_subreport.h"

struct layout_dim
{
  double                                m_org_y;
  double                                m_pos_y;
  double                                m_len_y;
};

extern void
layout_util_break_check(
  struct rw*const                       io_rw,
  struct layout_spec *const             io_layout)
{
  int                                   l_break;
  unsigned                              l_slot;

  do
  {

    layout_util_break_check_page(&l_break, io_layout, io_rw);
    layout_util_break_check_group(io_rw, io_layout, l_break);

    if (0 == l_break)
    {
      break;
    }

    layout_util_draw_footer(io_layout, io_rw);

    rw_item_set_value((*io_layout).m_report.m_header.m_item, io_rw);

    for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
    {
      rw_item_set_value((*io_layout).m_group[l_slot].m_header.m_item, io_rw);
    }

    layout_util_draw_headers(io_layout, io_rw);

  }while(0);

  return;
}

extern void
layout_util_break_check_group(
  struct rw*const                       io_rw,
  struct layout_spec *const             io_layout,
  int const                             i_in_page_break)
{
  struct iwsql_attr const*              l_attr;
  struct layout_spec_division_group*    l_group;
  double                                l_needed;
  int                                   l_rc;
  unsigned                              l_slot;

  l_slot= (*io_layout).m_group_slots;

  do
  {

    if (0 == l_slot)
    {
      break;
    }

    l_slot--;
    l_group= &(*io_layout).m_group[l_slot];

    rw_attr_lookup_by_name(
      &l_attr,
      &(*io_rw).m_exec,
      "primary",
      (*l_group).m_break.m_column);

    do
    {

      if (0 == l_attr)
      {
        break;
      }

      l_rc= strcmp((*l_group).m_break.m_value, (*l_attr).m_value);

      if (0 == l_rc)
      {
        break;
      }

      l_needed= (*io_rw).m_pos_y + (*l_group).m_footer.m_paper.m_height;

      if ((*io_rw).m_fence_bottom <= l_needed)
      {
        layout_util_draw_footer(io_layout, io_rw);
        layout_util_draw_headers(io_layout, io_rw);
      }

      layout_util_draw_division(&(*l_group).m_footer, io_rw);

      rw_item_clear_accumulator(
        (*l_group).m_footer.m_item,
        (*l_group).m_break.m_column);

      g_free((*l_group).m_break.m_value);
      (*l_group).m_break.m_value= g_strdup((*l_attr).m_value);

      if (i_in_page_break)
      {
        break;
      }

      l_needed= (*io_rw).m_pos_y + (*l_group).m_header.m_paper.m_height;

      if ((*io_rw).m_fence_bottom <= l_needed)
      {
        layout_util_draw_footer(io_layout, io_rw);
        layout_util_draw_headers(io_layout, io_rw);
        break;
      }

      rw_item_set_value((*l_group).m_header.m_item, io_rw);
      layout_util_draw_division(&(*l_group).m_header, io_rw);

    }while(0);

  }while(1);

  return;
}

extern void
layout_util_break_check_page(
  int*                                  o_break,
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw)
{
  struct layout_spec_division_break*    l_break;
  struct iwsql_attr const*              l_attr;
  int                                   l_rc;

  (*o_break)= 0;

  do
  {

    l_break= &(*io_layout).m_page_break;

    if (0 == (*l_break).m_column)
    {
      break;
    }

    rw_attr_lookup_by_name(
      &l_attr,
      &(*io_rw).m_exec,
      "primary",
      (*l_break).m_column);

    if (0 == l_attr)
    {
      break;
    }

    if ((*l_break).m_value)
    {
      l_rc= strcmp((*l_break).m_value, (*l_attr).m_value);
    }
    else
    {
      l_rc= -1;
    }

    if (l_rc)
    {
      g_free((*l_break).m_value);
      (*l_break).m_value= g_strdup((*l_attr).m_value);
      (*o_break)= 1;
    }

  }while(0);

  return;
}

extern void
layout_util_draw_division(
  struct layout_spec_division*const     io_division,
  struct rw*const                       io_rw)
{
  double                                l_bottom;
  struct item_draw_context              l_ctx;
  struct layout_dim*                    l_dim;
  unsigned                              l_dim_slots;
  double                                l_fence;
  double                                l_len_x;
  double                                l_len_y;
  struct item_node*                     l_node;
  double                                l_offset_y;
  double                                l_pos_x;
  double                                l_pos_y;
  double                                l_save_y;
  unsigned                              l_slot;

  memset(&l_ctx, 0, sizeof(l_ctx));
  l_ctx.m_cr= (*io_rw).m_cr;
  l_ctx.m_scale= 1.0;
  l_dim= 0;
  l_dim_slots= 0;
  l_fence= (*io_rw).m_pos_y;

  do
  {

    if (0 == (*io_division).m_item || 0 == (*io_division).m_item->m_head)
    {
      break;
    }

    l_node= (*io_division).m_item->m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      if (run_dialog_get_cancelled())
      {
        break;
      }

      (*(*l_node).m_method.m_get_position)(&l_pos_x, &l_pos_y, &(*l_node).m_object);
      (*(*l_node).m_method.m_get_size)(&l_len_x, &l_len_y, &(*l_node).m_object);

      l_offset_y= (*io_rw).m_pos_y;

      for (l_slot= 0; l_dim_slots > l_slot; l_slot++)
      {
        if (l_pos_y > l_dim[l_slot].m_org_y)
        {
          l_bottom= l_dim[l_slot].m_pos_y + l_dim[l_slot].m_len_y;
          if (l_offset_y < l_bottom)
          {
            l_offset_y= (l_bottom - l_pos_y) + (l_pos_y - l_dim[l_slot].m_org_y);
          }
        }
      }

      cairo_save((*io_rw).m_cr);
      cairo_translate((*io_rw).m_cr, (*io_rw).m_pos_x, l_offset_y);

      if (item_type_report != (*l_node).m_type)
      {
        (*(*l_node).m_method.m_draw)(&(*l_node).m_object, &l_ctx);
        l_bottom= l_offset_y + l_pos_y + l_len_y;
      }
      else
      {
        l_save_y= (*io_rw).m_pos_y;
        (*io_rw).m_pos_y= 0;
        layout_subreport(io_rw, &(*l_node).m_object.m_report);
        l_bottom= l_offset_y+(*io_rw).m_pos_y;
        l_dim= realloc(l_dim, (1 + l_dim_slots) * sizeof(*l_dim));
        l_dim[l_dim_slots].m_org_y= l_pos_y;
        l_dim[l_dim_slots].m_pos_y= l_offset_y + l_pos_y;
        l_dim[l_dim_slots].m_len_y= (*io_rw).m_pos_y - l_pos_y;
        l_dim_slots++;
        (*io_rw).m_pos_y= l_save_y;
      }

      cairo_restore((*io_rw).m_cr);

      if (l_fence < l_bottom)
      {
        l_fence= l_bottom;
      }

      l_node= (*l_node).m_next;

    }while(1);

  }while(0);

  g_free(l_dim);
  (*io_rw).m_pos_y= l_fence;

  return;
}

extern void
layout_util_draw_footer(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw)
{
  struct layout_spec_division*          l_footer;

  do
  {

    l_footer= &(*io_layout).m_report.m_footer;

    if (0 == (*l_footer).m_item || 0 == (*l_footer).m_item->m_head)
    {
      break;
    }

    (*io_rw).m_pos_y=
      ((*io_layout).m_paper.m_height - (*l_footer).m_paper.m_height);

    rw_item_set_value((*l_footer).m_item, io_rw);
    layout_util_draw_division(l_footer, io_rw);

  }while(0);

  if (0 == (*io_rw).m_prev)
  {
    cairo_show_page((*io_rw).m_cr);
    (*io_rw).m_pos_y= 0.0;
    (*io_rw).m_page_number++;
  }

  return;
}

extern void
layout_util_draw_group_footer(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw)
{
  unsigned                              l_slot;
  struct layout_spec_division_group*    l_group;

  l_slot= (*io_layout).m_group_slots;

  do
  {

    if (0 == l_slot)
    {
      break;
    }

    l_slot--;

    l_group= &(*io_layout).m_group[l_slot];
    layout_util_draw_division(&(*l_group).m_footer, io_rw);

  }while(1);

  return;
}

extern void
layout_util_draw_headers(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw)
{
  unsigned                              l_slot;

  layout_util_draw_division(&(*io_layout).m_report.m_header, io_rw);

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    layout_util_draw_division(&(*io_layout).m_group[l_slot].m_header, io_rw);
  }

  return;
}
