/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __layout_spec_h__

#include "global_common.h"
#include "database_aspect.h"
#include "item.h"
#include "iwr_page.h"
#include "paper.h"
#include "query.h"

struct layout_spec_division
{
  char*                                 m_label;
  enum iwr_page_section_type            m_type;
  struct item*                          m_item;	
  struct paper                          m_paper;
};

struct layout_spec_division_cover
{
  struct layout_spec_division           m_header;
  struct layout_spec_division           m_footer;
};

struct layout_spec_division_report
{
  struct layout_spec_division           m_header;
  struct layout_spec_division           m_detail;
  struct layout_spec_division           m_footer;
};

struct layout_spec_division_break
{
  char*                                 m_column;
  char*                                 m_value;
};

struct layout_spec_division_group
{
  struct layout_spec_division_break     m_break;
  struct layout_spec_division           m_header;
  struct layout_spec_division           m_footer;
};

struct layout_spec
{
  struct database_aspect                m_aspect;
  struct query                          m_query;
  struct paper                          m_paper;
  struct layout_spec_division_cover     m_cover;
  struct layout_spec_division_report    m_report;
  struct layout_spec_division_break     m_page_break;
  struct layout_spec_division_group*    m_group;
  unsigned                              m_group_slots;
};

extern void
layout_spec_assign(
  struct layout_spec*const              o_layout);

extern void
layout_spec_paper_convert_to_points(
  struct layout_spec*const              io_spec);

extern void
layout_spec_discharge(
  struct layout_spec*const              io_layout);

extern int
layout_spec_read(
  GError**                              o_error,
  struct layout_spec*const              io_layout,
  struct xml *const                     i_xml);

#define __layout_spec_h__
#endif
