/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "layout_loop.h"

extern int
layout_loop(
  GError**                              o_error,
  struct rw*const                       io_rw,
  struct layout_spec *const             io_layout)
{
  struct layout_spec_division*          l_detail;
  int                                   l_eof;
  int                                   l_exit;
  struct paper                          l_paper_detail;
  gint64                                l_time1;
  gint64                                l_time2;

  l_detail= &(*io_layout).m_report.m_detail;

  if ((*l_detail).m_item && (*l_detail).m_item->m_head)
  {
    l_paper_detail= (*l_detail).m_paper;
  }
  else
  {
    memset(&l_paper_detail, 0, sizeof(l_paper_detail));
  }

  l_exit= 0;
  l_time1= 0;

  do
  {

    run_dialog_increment_tuple();

    if ((*io_rw).m_interactive)
    {
      l_time2= g_get_monotonic_time();
      if ((G_USEC_PER_SEC / 2.0) < (l_time2 - l_time1))
      {
        l_time1= l_time2;
        gdk_threads_add_idle(run_dialog_update, (gpointer)g_run_dialog.m_status_active);
      }
    }

    rw_item_set_value((*l_detail).m_item, io_rw);
    layout_util_draw_division(l_detail, io_rw);

    if (run_dialog_get_cancelled())
    {
      cairo_show_page((*io_rw).m_cr);
      l_exit= -1;
      break;
    }

    rw_layout_group_set_value(io_layout, io_rw);

    l_exit= query_exec_next(o_error, &l_eof, &(*io_rw).m_exec);

    if (l_exit)
    {
      break;
    }

    if (l_eof)
    {
      layout_util_draw_group_footer(io_layout, io_rw);
      layout_util_draw_footer(io_layout, io_rw);
      break;
    }

    layout_util_break_check(io_rw, io_layout);

    if ((*io_rw).m_fence_bottom <= ((*io_rw).m_pos_y + l_paper_detail.m_height))
    {
      layout_util_draw_footer(io_layout, io_rw);
      layout_util_draw_headers(io_layout, io_rw);
    }

  }while(1);

  if ((*io_rw).m_interactive)
  {
    gdk_threads_add_idle(run_dialog_update, (gpointer)g_run_dialog.m_status_active);
  }

  return l_exit;
}
