/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "label_spec.h"

extern void
label_spec_assign(
  struct label_spec*const               o_label)
{

  memset(o_label, 0, sizeof(*o_label));
  label_paper_assign(&(*o_label).m_paper);
  database_aspect_assign(&(*o_label).m_aspect);
  query_assign(&(*o_label).m_query);

  return;
}

extern void
label_spec_discharge(
  struct label_spec*const               io_label)
{

  label_paper_discharge(&(*io_label).m_paper);
  database_aspect_discharge(&(*io_label).m_aspect);
  query_discharge(&(*io_label).m_query);

  return;
}

extern int
label_spec_read_section(
  GError**                              o_error,
  struct label_spec*const               io_label,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  GList*                                l_node;
  int                                   l_rc;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;
  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (struct xml*)(*l_node).data;

    l_rc= strcmp("item", (*l_xml).m_tag);

    if (0 == l_rc)
    {
      l_exit= item_read(&l_error, &(*io_label).m_report.m_item, l_xml);
    }

    if (l_exit)
    {
      break;
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern int
label_spec_read(
  GError**                              o_error,
  struct label_spec*const               io_label,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_has_aspect;
  int                                   l_has_paper;
  int                                   l_has_query;
  int                                   l_has_section;
  GList*                                l_node;
  int                                   l_rc;
  struct xml*                           l_xml;

  l_error= 0;
  l_has_aspect= 0;
  l_has_paper= 0;
  l_has_query= 0;
  l_has_section= 0;
  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (*l_node).data;

    do
    {

      l_rc= strcmp("aspect", (*l_xml).m_tag);
  
      if (0 == l_rc)
      {
        if (l_has_aspect)
        {
          l_error= g_error_new(
            LABEL_SPEC,
            LABEL_SPEC_XML_DUPLICATE_ASPECT,
            "Duplicate 'aspect' element");
          l_exit= -1;
          _error_log(l_error);
          break; 
        }
        l_has_aspect= 1;
        l_exit= database_aspect_read(&l_error, &(*io_label).m_aspect, l_xml);
        break;
      }

      l_rc= strcmp("query", (*l_xml).m_tag);

      if (0 == l_rc)
      {
        if (l_has_query)
        {
          l_error= g_error_new(
            LABEL_SPEC,
            LABEL_SPEC_XML_DUPLICATE_QUERY,
            "Duplicate 'query' element");
          _error_log(l_error);
          l_exit= -1;
          break; 
        }
        l_has_query= 1;
        l_exit= query_read(&l_error, &(*io_label).m_query, l_xml);
        break;
      }

      l_rc= strcmp("paper", (*l_xml).m_tag);

      if (0 == l_rc)
      {
        if (l_has_paper)
        {
          l_error= g_error_new(
            LABEL_SPEC,
            LABEL_SPEC_XML_DUPLICATE_PAPER,
            "Duplicate 'paper' element");
          _error_log(l_error);
          l_exit= -1;
          break; 
        }
        l_has_paper= 1;
        l_exit= label_paper_read(&l_error, &(*io_label).m_paper, l_xml);
        break;
      }

      l_rc= strcmp("section", (*l_xml).m_tag);

      if (0 == l_rc)
      {
        if (l_has_section)
        {
          l_error= g_error_new(
            LABEL_SPEC,
            LABEL_SPEC_XML_DUPLICATE_SECTION,
            "Duplicate 'section' element");
          _error_log(l_error);
          l_exit= -1;
          break; 
        }
        l_has_section= 1;
        l_exit= label_spec_read_section(&l_error, io_label, l_xml);
        break;
      }

      g_warning("Unkown element ('%s')", (*l_xml).m_tag);

    }while(0);

    if (l_exit)
    {
      break;
    }
  
    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}
