/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __label_paper_h__

#include "global_common.h"
#include "paper.h"

/* _
mjo: TODO add enum { paper_is_inches, paper_is_points }
for converstion routines
*/

struct label_paper
{
  gdouble                               m_page_width;
  gdouble                               m_page_height;
  gdouble                               m_top_margin;
  gdouble                               m_left_margin;
  gdouble                               m_horizontal_pitch;
  gdouble                               m_vertical_pitch;
  gdouble                               m_label_width;
  gdouble                               m_label_height;
  guint64                               m_columns;
  guint64                               m_rows;
};

extern void
label_paper_assign(
  struct label_paper*const              o_paper);

extern void
label_paper_convert_to_inches(
  struct label_paper*const              io_paper);

extern void
label_paper_convert_to_points(
  struct label_paper*const              io_paper);

extern void
label_paper_discharge(
  struct label_paper*const              io_paper);

extern int
label_paper_read(
  GError**                              o_error,
  struct label_paper*const              io_paper,
  struct xml *const                     i_xml);

extern void
label_paper_set_defaults(
  struct label_paper*const              o_paper);

extern int
label_paper_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct label_paper const*const        i_paper);

#define  __label_paper_h__
#endif
