/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __label_h__

#include "label_spec.h"
#include "iwr_page.h"

struct label
{
  struct label_paper                    m_paper;
  double                                m_scale;
  GtkScrolledWindow*                    m_window;
  GtkLayout*                            m_layout;
  IwrPage*                              m_page;
};

extern void
label_assign(
  struct label*const                    o_label);

extern void
label_discharge(
  struct label*const                    io_label);

extern GtkWidget*
label_gui_new(
  struct label*const                    io_label);

extern void
label_highlight_objects(
  struct label*const                    io_label,
  gboolean const                        i_state);

extern struct item_node*
label_item_new(
  struct label*const                    io_label,
  enum item_type const                  i_type);

extern int
label_page_setup_property(
  struct label_paper*const              io_paper);

extern void
label_paper_changed(
  struct label*const                    io_label);

extern void
label_set_horizontal_ruler_line(
  struct label *const                   io_label,
  gboolean const                        i_state);

extern void
label_set_scale(
  struct label *const                   io_label,
  double const                          i_scale);

extern void
label_set_scale_zoom_in(
  struct label *const                   io_label);

extern void
label_set_scale_zoom_out(
  struct label *const                   io_label);

extern void
label_set_vertical_ruler_line(
  struct label *const                   io_label,
  gboolean const                        i_state);

extern void
label_size_allocate(
  struct label*const                    io_label,
  GdkRectangle const*const              i_alloc);

extern int
label_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct label const*const              i_label);

#define __label_h__
#endif
