/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "iwr_page.h"
#include "mainw.h"

extern struct mainw*                    g_mainw;

static void
iwr_page_menu_get_selected(
  struct item_node**                    o_node,
  struct item*const                     i_item)
{
  struct item_node*                     l_node;
  struct item_node*                     l_node2;

  (*o_node)= 0;
  l_node= (*i_item).m_head;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    if ((*l_node).m_selected)
    {
      l_node2= (*l_node).m_next;

      do
      {

        if (0 == l_node2)
        {
          (*o_node)= l_node;
          break;
        }

        if ((*l_node2).m_selected)
        {
          break;
        }

        l_node2= (*l_node2).m_next;

      }while(1); 

      break;
    }

    l_node= (*l_node).m_next;

  }while(1);

  return;
}

static void
iwr_page_menu_move_to_back(
  GtkMenuItem*                          i_menuitem,
  gpointer                              i_user_data)
{
  struct item*                          l_item;
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_page= (IwrPage*)i_user_data;
  iwr_page_get_item(&l_item, l_page);
  iwr_page_menu_get_selected(&l_node, l_item);

  if (l_node)
  {
    mainw_cmd_push(g_mainw, l_page, cmd_order);
    item_move_to_back(l_item, l_node);
  }

  return;
}

static void
iwr_page_menu_move_to_front(
  GtkMenuItem*                          i_menuitem,
  gpointer                              i_user_data)
{
  struct item*                          l_item;
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_page= (IwrPage*)i_user_data;
  iwr_page_get_item(&l_item, l_page);
  iwr_page_menu_get_selected(&l_node, l_item);

  if (l_node)
  {
    mainw_cmd_push(g_mainw, l_page, cmd_order);
    item_move_to_front(l_item, l_node);
  }

  return;
}

static void
iwr_page_menu_move_down(
  GtkMenuItem*                          i_menuitem,
  gpointer                              i_user_data)
{
  struct item*                          l_item;
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_page= (IwrPage*)i_user_data;
  iwr_page_get_item(&l_item, l_page);
  iwr_page_menu_get_selected(&l_node, l_item);

  if (l_node)
  {
    mainw_cmd_push(g_mainw, l_page, cmd_order);
    item_move_down(l_item, l_node);
  }

  return;
}

static void
iwr_page_menu_move_up(
  GtkMenuItem*                          i_menuitem,
  gpointer                              i_user_data)
{
  struct item*                          l_item;
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_page= (IwrPage*)i_user_data;
  iwr_page_get_item(&l_item, l_page);
  iwr_page_menu_get_selected(&l_node, l_item);

  if (l_node)
  {
    mainw_cmd_push(g_mainw, l_page, cmd_order);
    item_move_up(l_item, l_node);
  }

  return;
}

extern GtkMenu*
iwr_page_menu_new(
  IwrPage*const                         i_page)
{
  GtkMenu*                              l_menu;
  GtkWidget*                            l_item;

  l_menu= GTK_MENU(gtk_menu_new());

  l_item= gtk_menu_item_new_with_label("Move up");
  gtk_menu_shell_append(GTK_MENU_SHELL(l_menu), l_item);
  g_signal_connect(
    G_OBJECT(l_item),
    "activate",
    G_CALLBACK(iwr_page_menu_move_up),
    i_page);

  l_item= gtk_menu_item_new_with_label("Move down");
  gtk_menu_shell_append(GTK_MENU_SHELL(l_menu), l_item);
  g_signal_connect(
    G_OBJECT(l_item),
    "activate",
    G_CALLBACK(iwr_page_menu_move_down),
    i_page);

  l_item= gtk_separator_menu_item_new();
  gtk_menu_shell_append(GTK_MENU_SHELL(l_menu), l_item);

  l_item= gtk_menu_item_new_with_label("Move to front");
  gtk_menu_shell_append(GTK_MENU_SHELL(l_menu), l_item);
  g_signal_connect(
    G_OBJECT(l_item),
    "activate",
    G_CALLBACK(iwr_page_menu_move_to_front),
    i_page);

  l_item= gtk_menu_item_new_with_label("Move to back");
  gtk_menu_shell_append(GTK_MENU_SHELL(l_menu), l_item);
  g_signal_connect(
    G_OBJECT(l_item),
    "activate",
    G_CALLBACK(iwr_page_menu_move_to_back),
    i_page);

  return l_menu;
}
