/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_report.h"
#include "item_property.h"

struct report_dialog
{
  GtkEntry*                             m_report_entry;
  GtkButton*                            m_file_button;
};

static void
item_report_file_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkFileChooser*                       l_chooser;
  GtkWidget*                            l_dialog;
  GtkEntry*                             l_entry;
  char*                                 l_filename;
  GtkFileFilter*                        l_filter;
  gint                                  l_rc;

  l_entry= GTK_ENTRY(i_data);

  l_dialog = gtk_file_chooser_dialog_new(
    "Open Report",
    get_main_window(),
    GTK_FILE_CHOOSER_ACTION_OPEN,
    "_Cancel",
    GTK_RESPONSE_CANCEL,
    "_Ok",
    GTK_RESPONSE_ACCEPT,
    NULL);

  l_chooser= GTK_FILE_CHOOSER(l_dialog);

  l_filter= gtk_file_filter_new();
  gtk_file_filter_add_pattern(l_filter, "*.irpt");
  gtk_file_filter_set_name(l_filter, "iwrite report");
  gtk_file_chooser_add_filter(l_chooser, l_filter);

  do
  {

    l_rc= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_ACCEPT != l_rc)
    {
      break;
    }

    l_filename= gtk_file_chooser_get_filename(l_chooser);

    if (0 == l_filename)
    {
      break;
    }

    gtk_entry_set_text(l_entry, l_filename);

    g_free(l_filename);

  }while(0);

  gtk_widget_destroy(l_dialog); 

  return;
}

static void
item_report_bind(
  struct report_dialog*const            o_dlg,
  GtkBuilder*const                      i_builder)
{

  memset(o_dlg, 0, sizeof(*o_dlg));

  do
  {

    (*o_dlg).m_report_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "report_entry"));

    (*o_dlg).m_file_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "file_button"));

    g_signal_connect(
      (*o_dlg).m_file_button,
      "clicked",
      G_CALLBACK(item_report_file_button_cb),
      (*o_dlg).m_report_entry);


  }while(0);

  return;
}

static void
item_report_set_values(
  struct report_dialog*const            io_dlg,
  struct item_report const*const        i_object)
{

  if ((*i_object).m_filename)
  {
    gtk_entry_set_text((*io_dlg).m_report_entry, (*i_object).m_filename);
  }

  return;
}

static void
item_report_copy_values(
  struct item_report *const             io_object,
  struct report_dialog const*const      i_dlg)
{
  gchar const*                          l_text;

  l_text= gtk_entry_get_text((*i_dlg).m_report_entry);

  g_free((*io_object).m_filename);
  (*io_object).m_filename= 0;

  if (l_text && l_text[0])
  {
    (*io_object).m_filename= g_strdup(l_text);
  }

  return;
}

extern int
item_report_property(
  struct item_report*const              io_object)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  struct report_dialog                  l_dlg;
  GError*                               l_error;
  int                                   l_exit;
  GtkGrid*                              l_grid;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "report.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "report_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'report_grid'");
      l_exit= -1;
      break;
    }

    item_report_bind(&l_dlg, l_builder);

    item_report_set_values(&l_dlg, io_object);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Report Edit",
      get_main_window(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_report_copy_values(io_object, &l_dlg);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

