/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_report_h__

#include "item_common.h"
#include "item_method.h"

struct item_report
{
  struct geom_rect                      m_box;
  gchar*                                m_filename;
};

extern void
item_report_assign(
  struct item_report*const              o_object,
  struct item_method*const              o_method);

extern void
item_report_copy(
  struct item_report *const             o_object,
  struct item_report const*const        i_object);

extern void
item_report_discharge(
  struct item_report*const              io_object);

extern void
item_report_draw(
  struct item_report const*const        i_object,
  struct item_draw_context const*const  i_ctx);

extern void
item_report_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  struct item_report const*const        i_object);

extern void
item_report_get_position(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  struct item_report const*const        i_object);

extern void
item_report_get_rotation(
  double*const                          o_rotation,
  struct item_report const*const        i_object);

extern void
item_report_get_size(
  double*const                          o_len_x,
  double*const                          o_len_y,
  struct item_report const*const        i_object);

extern void
item_report_get_shear(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  struct item_report const*const        i_object);

extern int
item_report_in_event(
  struct item_report const*const        i_object,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx);

extern void
item_report_move(
  struct item_report*const              io_object,
  struct geom_point const*const         i_event);

extern void
item_report_normalize(
  struct item_report*const              io_object);

extern void
item_report_set_position(
  struct item_report*const              io_object,
  double const                          i_pos_x,
  double const                          i_pos_y);

extern void
item_report_set_rotation(
  struct item_report*const              io_object,
  double                                i_rotation);

extern void
item_report_set_size(
  struct item_report*const              io_object,
  double                                i_len_x,
  double                                i_len_y);

extern void
item_report_set_shear(
  struct item_report*const              io_object,
  double const                          i_shear_x,
  double const                          i_shear_y);

extern int
item_report_property(
  struct item_report*const              io_object);

extern int
item_report_read(
  GError**                              o_error,
  struct item_report*const              io_object,
  struct xml *const                     i_xml);

extern void
item_report_resize(
  struct item_report*const              io_object,
  struct item_resize_event const*const  i_ctx);

extern void
item_report_rotate(
  struct item_report*const              io_object,
  double const                          i_rotation);
  
extern void
item_report_shear(
  struct item_report*const              io_object,
  double const                          i_delta_x,
  double const                          i_delta_y);

extern int
item_report_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_report const*const        i_object);

#define __item_report_h__
#endif
