/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_report.h"

extern void
item_report_assign(
  struct item_report*const              o_object,
  struct item_method*const              o_method)
{

  memset(o_object, 0, sizeof(*o_object));
  (*o_object).m_box.m_len_x= 30.0;
  (*o_object).m_box.m_len_y= 18.0;

  ITEM_METHOD_ASSIGN(o_method, report);

  return;
}

extern void
item_report_copy(
  struct item_report *const             o_object,
  struct item_report const*const        i_object)
{

  memcpy(o_object, i_object, sizeof(*o_object));
  (*o_object).m_filename= g_strdup((*o_object).m_filename);

  return;
}

extern void
item_report_discharge(
  struct item_report*const              io_object)
{

  g_free((*io_object).m_filename);

  return;
}

extern void
item_report_draw(
  struct item_report const*const        i_object,
  struct item_draw_context const*const  i_ctx)
{
  PangoLayout*                          l_layout;
  char const*                           l_text;

  do
  {

    if (item_draw_print == (*i_ctx).m_option.m_type)
    {
      break;
    }

    l_text= "Report";

    cairo_new_path((*i_ctx).m_cr);
    cairo_save((*i_ctx).m_cr);

    l_layout= pango_cairo_create_layout((*i_ctx).m_cr);
    pango_layout_set_text(l_layout, l_text, -1);
    cairo_translate((*i_ctx).m_cr, (*i_object).m_box.m_pos_x, (*i_object).m_box.m_pos_y);
    pango_cairo_update_layout((*i_ctx).m_cr, l_layout);
    pango_cairo_show_layout((*i_ctx).m_cr, l_layout);

    cairo_restore((*i_ctx).m_cr);
    g_object_unref(l_layout);

  }while(0);

  return;
}

extern void
item_report_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  struct item_report const*const        i_object)
{
  struct item_transform                 l_transform;

  memset(&l_transform, 0, sizeof(l_transform));
  item_common_box_get_bbox(o_bbox, io_cr, &(*i_object).m_box, &l_transform, i_scale);

  return;
}

extern void
item_report_get_position(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  struct item_report const*const        i_object)
{

  (*o_pos_x)= (*i_object).m_box.m_pos_x;
  (*o_pos_y)= (*i_object).m_box.m_pos_y;

  return;
}

extern void
item_report_get_rotation(
  double*const                          o_rotation,
  struct item_report const*const        i_object)
{

  (*o_rotation)= 0.0; 

  return;
}

extern void
item_report_get_size(
  double*const                          o_len_x,
  double*const                          o_len_y,
  struct item_report const*const        i_object)
{

  (*o_len_x)= (*i_object).m_box.m_len_x;
  (*o_len_y)= (*i_object).m_box.m_len_y;

  return;
}

extern void
item_report_get_shear(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  struct item_report const*const        i_object)
{

  (*o_shear_x)= 0.0;
  (*o_shear_y)= 0.0;

  return;
}

extern int
item_report_in_event(
  struct item_report const*const        i_object,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx)
{
  int                                   l_hit;
  struct item_transform                 l_transform;

  memset(&l_transform, 0, sizeof(l_transform));
  l_hit= item_common_box_in_event(io_cr, &(*i_object).m_box, &l_transform, i_ctx);

  return l_hit;
}

extern void
item_report_move(
  struct item_report*const              io_object,
  struct geom_point const*const         i_event)
{

  item_common_box_move(&(*io_object).m_box, i_event);

  return;
}

extern void
item_report_normalize(
  struct item_report*const              io_object)
{

  item_common_box_normalize(&(*io_object).m_box);

  return;
}

extern void
item_report_set_position(
  struct item_report*const              io_object,
  double const                          i_pos_x,
  double const                          i_pos_y)
{

  (*io_object).m_box.m_pos_x= i_pos_x;
  (*io_object).m_box.m_pos_y= i_pos_y;

  return;
}

extern void
item_report_set_rotation(
  struct item_report*const              io_object,
  double                                i_rotation)
{
  return;
}

extern void
item_report_set_size(
  struct item_report*const              io_object,
  double                                i_len_x,
  double                                i_len_y)
{

  (*io_object).m_box.m_len_x= i_len_x;
  (*io_object).m_box.m_len_y= i_len_y;

  return;
}

extern void
item_report_set_shear(
  struct item_report*const              io_object,
  double const                          i_shear_x,
  double const                          i_shear_y)
{
  return;
}

extern int
item_report_read(
  GError**                              o_error,
  struct item_report*const              io_object,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_found;
  GList*                                l_node;
  enum element_tag_type                 l_type;
  char const*                           l_value;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_rect:
          item_common_box_read(&l_error, &(*io_object).m_box, l_xml);
          break;
        case element_tag_filename:
          if (l_value[0])
          {
            (*io_object).m_filename= g_strdup(l_value);
          }
          break;
        default:
          break;
      }
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
item_report_resize(
  struct item_report*const              io_object,
  struct item_resize_event const*const  i_ctx)
{
  struct item_transform                 l_transform;

  memset(&l_transform, 0, sizeof(l_transform));
  item_common_box_resize(&(*io_object).m_box, i_ctx, &l_transform);

  return;
}

extern void
item_report_rotate(
  struct item_report*const              io_object,
  double const                          i_rotation)
{
  return;
}
  
extern void
item_report_shear(
  struct item_report*const              io_object,
  double const                          i_delta_x,
  double const                          i_delta_y)
{
  return;
}

extern int
item_report_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_report const*const        i_object)
{

  fprintf(io_fp, "\t\t\t<item name=\"report\">\n");
  item_common_box_write(o_error, io_fp, &(*i_object).m_box);
  fprintf(io_fp, "\t\t\t\t<filename>%s</filename>\n", ((*i_object).m_filename ? (*i_object).m_filename : ""));
  fprintf(io_fp, "\t\t\t</item>\n");

  return 0;
}
