/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_method_h__

#include "item_common.h"

typedef void
(*item_method_copy_t)(
  void*const                            o_object,
  void const*const                      i_object);

typedef void
(*item_method_discharge_t)(
  void*const                            io_object);

typedef void
(*item_method_draw_t)(
  void const*const               	      i_object,
  struct item_draw_context const*const  i_ctx);

typedef void
(*item_method_get_bbox_t)(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  void const*const                      i_object);

typedef void
(*item_method_get_position_t)(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  void const*const                      i_object);

typedef void
(*item_method_get_rotation_t)(
  double*const                          o_rotation,
  void const*const                      i_object);

typedef void
(*item_method_get_size_t)(
  double*const                          o_len_x,
  double*const                          o_len_y,
  void const*const                      i_object);

typedef void
(*item_method_get_shear_t)(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  void const*const                      i_object);

typedef int
(*item_method_in_event_t)(
  void const*const                      i_object,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx);

typedef void
(*item_method_move_t)(
  void*const                            io_object,
  struct geom_point const*const         i_event);

typedef void
(*item_method_normalize_t)(
  void*const                            io_object);

typedef void
(*item_method_set_position_t)(
  void*const                            io_object,
  double const                          i_pos_x,
  double const                          i_pos_y);

typedef void
(*item_method_set_rotation_t)(
  void*const                            io_object,
  double                                i_rotation);

typedef void
(*item_method_set_size_t)(
  void*const                            io_object,
  double                                i_len_x,
  double                                i_len_y);

typedef void
(*item_method_set_shear_t)(
  void*const                            io_object,
  double                                i_shear_x,
  double                                i_shear_y);

typedef void
(*item_method_property_t)(
  void*const                            io_object);

typedef int
(*item_method_read_t)(
  GError**                              o_error,
  void*const                            io_object,
  struct xml *const                     i_xml);

typedef void
(*item_method_resize_t)(
  void*const                            io_object,
  struct item_resize_event const*const  i_ctx);

typedef void
(*item_method_rotate_t)(
  void*const                            io_object,
  double const                          i_rotation);

typedef void
(*item_method_shear_t)(
  void*const                            io_object,
  double const                          i_delta_x,
  double const                          i_delta_y);

typedef int
(*item_method_write_t)(
  GError**                              o_error,
  FILE*const                            io_fp,
  void const*const                      i_object);

struct item_method
{
  item_method_copy_t                    m_copy;
  item_method_discharge_t               m_discharge;
  item_method_draw_t                    m_draw;
  item_method_get_bbox_t                m_get_bbox;

  item_method_get_position_t            m_get_position;
  item_method_get_rotation_t            m_get_rotation;
  item_method_get_size_t                m_get_size;
  item_method_get_shear_t               m_get_shear;

  item_method_in_event_t                m_in_event;
  item_method_move_t                    m_move;
  item_method_normalize_t               m_normalize;
  item_method_property_t                m_property;
  item_method_read_t                    m_read;
  item_method_resize_t                  m_resize;
  item_method_rotate_t                  m_rotate;

  item_method_set_position_t            m_set_position;
  item_method_set_rotation_t            m_set_rotation;
  item_method_set_size_t                m_set_size;
  item_method_set_shear_t               m_set_shear;

  item_method_shear_t                   m_shear;
  item_method_write_t                   m_write;
};

#define ITEM_METHOD_ASSIGN(o_method, i_module) \
  do \
  { \
    memset((o_method), 0, sizeof((*(o_method)))); \
    (*(o_method)).m_copy= (item_method_copy_t) \
      item_ ## i_module ## _copy; \
    (*(o_method)).m_discharge= (item_method_discharge_t) \
      item_ ## i_module ## _discharge; \
    (*(o_method)).m_draw= (item_method_draw_t) \
      item_ ## i_module ## _draw; \
    (*(o_method)).m_get_bbox= (item_method_get_bbox_t) \
      item_ ## i_module ## _get_bbox; \
    (*(o_method)).m_get_position= (item_method_get_position_t) \
      item_ ## i_module ## _get_position; \
    (*(o_method)).m_get_rotation= (item_method_get_rotation_t) \
      item_ ## i_module ## _get_rotation; \
    (*(o_method)).m_get_size= (item_method_get_size_t) \
      item_ ## i_module ## _get_size; \
    (*(o_method)).m_get_shear= (item_method_get_shear_t) \
      item_ ## i_module ## _get_shear; \
    (*(o_method)).m_in_event= (item_method_in_event_t) \
      item_ ## i_module ## _in_event; \
    (*(o_method)).m_move= (item_method_move_t) \
      item_ ## i_module ## _move; \
    (*(o_method)).m_normalize= (item_method_normalize_t) \
      item_ ## i_module ## _normalize; \
    (*(o_method)).m_property= (item_method_property_t) \
      item_ ## i_module ## _property; \
    (*(o_method)).m_read= (item_method_read_t) \
      item_ ## i_module ## _read; \
    (*(o_method)).m_resize= (item_method_resize_t) \
      item_ ## i_module ## _resize; \
    (*(o_method)).m_rotate= (item_method_rotate_t) \
      item_ ## i_module ## _rotate; \
    (*(o_method)).m_set_position= (item_method_set_position_t) \
      item_ ## i_module ## _set_position; \
    (*(o_method)).m_set_rotation= (item_method_set_rotation_t) \
      item_ ## i_module ## _set_rotation; \
    (*(o_method)).m_set_size= (item_method_set_size_t) \
      item_ ## i_module ## _set_size; \
    (*(o_method)).m_set_shear= (item_method_set_shear_t) \
      item_ ## i_module ## _set_shear; \
    (*(o_method)).m_shear= (item_method_shear_t) \
      item_ ## i_module ## _shear; \
    (*(o_method)).m_write= (item_method_write_t) \
      item_ ## i_module ## _write; \
  }while(0)

#define __item_method_h__
#endif
