/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fbarcode.h"
#include "item_property.h"

struct fbarcode_dialog
{
  GtkComboBoxText*                      m_symbology_comboboxtext;
  GtkSpinButton*                        m_scale_spinbutton;
  struct item_table_dialog              m_table;
};

static void
item_fbarcode_load_symbology(
  struct fbarcode_dialog*const          o_dlg)
{
  unsigned                              l_slot;

  l_slot= 0;

  do
  {

    if (0 == g_symtab[l_slot].m_name)
    {
      break;
    }

    gtk_combo_box_text_append_text(
      (*o_dlg).m_symbology_comboboxtext,
      g_symtab[l_slot].m_name);

    l_slot++;

  }while(1);

  return;
}

static void
item_fbarcode_bind(
  struct fbarcode_dialog*const          o_dlg,
  GtkBuilder*const                      i_builder)
{

  memset(o_dlg, 0, sizeof(*o_dlg));

  do
  {

    (*o_dlg).m_symbology_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "symbology_comboboxtext"));

    item_fbarcode_load_symbology(o_dlg);

    (*o_dlg).m_scale_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "scale_spinbutton"));

    (*o_dlg).m_table.m_query_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "query_comboboxtext"));

    (*o_dlg).m_table.m_column_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "column_comboboxtext"));

    item_property_load_query((*o_dlg).m_table.m_query_comboboxtext);

    g_signal_connect(
      (*o_dlg).m_table.m_query_comboboxtext,
      "changed",
      G_CALLBACK(item_property_comboboxtext_cb),
      &(*o_dlg).m_table);

  }while(0);

  return;
}

static void
item_fbarcode_set_values(
  struct fbarcode_dialog*const            io_dlg,
  struct item_fbarcode const*const        i_object)
{
  int                                     l_index;

  l_index= symbology_lookup_by_type((*i_object).m_barcode);

  if (-1 != l_index)
  {
    gtk_combo_box_set_active(GTK_COMBO_BOX((*io_dlg).m_symbology_comboboxtext), l_index);
  }

  item_property_database_set_active(
    (*io_dlg).m_table.m_query_comboboxtext,
    (*io_dlg).m_table.m_column_comboboxtext,
    &(*i_object).m_table);

  gtk_spin_button_set_value((*io_dlg).m_scale_spinbutton, (*i_object).m_scale);

  return;
}

static void
item_fbarcode_copy_values(
  struct item_fbarcode *const           io_object,
  struct fbarcode_dialog const*const    i_dlg)
{
  gint                                  l_rc;

  l_rc= gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_dlg).m_symbology_comboboxtext));
  
  if (0 <= l_rc)
  {
    (*io_object).m_barcode= g_symtab[l_rc].m_type;
  }
  else
  {
    (*io_object).m_barcode= BARCODE_UNKOWN;
  }

  (*io_object).m_scale= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_dlg).m_scale_spinbutton));

  if (0.50 > (*io_object).m_scale)
  {
    (*io_object).m_scale= 0.50;
  }

  g_free((*io_object).m_table.m_query);
  (*io_object).m_table.m_query= 
    gtk_combo_box_text_get_active_text((*i_dlg).m_table.m_query_comboboxtext);

  g_free((*io_object).m_table.m_column);
  (*io_object).m_table.m_column= 
    gtk_combo_box_text_get_active_text((*i_dlg).m_table.m_column_comboboxtext);

  return;
}

extern int
item_fbarcode_property(
  struct item_fbarcode*const            io_object)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  struct fbarcode_dialog                l_dlg;
  GError*                               l_error;
  int                                   l_exit;
  GtkGrid*                              l_grid;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "fbarcode.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "fbarcode_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'fbarcode_grid'");
      l_exit= -1;
      break;
    }

    item_fbarcode_bind(&l_dlg, l_builder);

    item_fbarcode_set_values(&l_dlg, io_object);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Barcode Edit",
      get_main_window(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_fbarcode_copy_values(io_object, &l_dlg);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

