/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_common_attr_h_

#include "global_common.h"
#include "icu.h"

enum element_tag_type
{
  element_tag_attribute,
  element_tag_autowrap,
  element_tag_bits_per_sample,
  element_tag_border,
  element_tag_center_x,
  element_tag_center_y,
  element_tag_channels,
  element_tag_circle,
  element_tag_color,
  element_tag_colorspace,
  element_tag_column,
  element_tag_columns,
  element_tag_cover_footer,
  element_tag_cover_header,
  element_tag_data,
  element_tag_data_type,
  element_tag_date,
  element_tag_date_style,
  element_tag_dbname,
  element_tag_doubleline,
  element_tag_driver,
  element_tag_ellipse,
  element_tag_encode,
  element_tag_fbarcode,
  element_tag_filename,
  element_tag_fill,
  element_tag_fimage,
  element_tag_fnumber,
  element_tag_font,
  element_tag_format,
  element_tag_frame,
  element_tag_fsum,
  element_tag_ftext,
  element_tag_group,
  element_tag_group_footer,
  element_tag_group_header,
  element_tag_has_alpha,
  element_tag_height,
  element_tag_horizontal_pitch,
  element_tag_host,
  element_tag_hostaddr,
  element_tag_image,
  element_tag_iwrite,
  element_tag_label,
  element_tag_label_height,
  element_tag_label_width,
  element_tag_left_margin,
  element_tag_len,
  element_tag_length,
  element_tag_len_x,
  element_tag_len_y,
  element_tag_line,
  element_tag_locale,
  element_tag_margin_bottom,
  element_tag_margin_left,
  element_tag_margin_right,
  element_tag_margin_top,
  element_tag_name,
  element_tag_orientation,
  element_tag_overlay,
  element_tag_page,
  element_tag_page_height,
  element_tag_page_number,
  element_tag_page_width,
  element_tag_pattern,
  element_tag_port,
  element_tag_pos_x,
  element_tag_pos_x1,
  element_tag_pos_x2,
  element_tag_pos_y,
  element_tag_pos_y1,
  element_tag_pos_y2,
  element_tag_print_header,
  element_tag_prompt_password,
  element_tag_query,
  element_tag_rect,
  element_tag_rect_v0,
  element_tag_rect_v1,
  element_tag_rect_v2,
  element_tag_rect_v3,
  element_tag_rect_v4,
  element_tag_rect_v5,
  element_tag_rect_v6,
  element_tag_rect_v7,
  element_tag_report,
  element_tag_report_detail,
  element_tag_report_footer,
  element_tag_report_header,
  element_tag_rotation,
  element_tag_rows,
  element_tag_rowstride,
  element_tag_scale,
  element_tag_shear_x,
  element_tag_shear_y,
  element_tag_size,
  element_tag_special,
  element_tag_style,
  element_tag_table,
  element_tag_tag,
  element_tag_text,
  element_tag_textual,
  element_tag_thickness,
  element_tag_time_style,
  element_tag_timezone,
  element_tag_top_margin,
  element_tag_transform,
  element_tag_type,
  element_tag_username,
  element_tag_value,
  element_tag_vertical_pitch,
  element_tag_width,
  element_tag_wrapmode
};

enum line_style_type
{
  line_style_solid=                     0,
  line_style_dash,
  line_style_dot,
  line_style_dash_dot,
  line_style_last
};

enum number_type
{
  number_float= 0,
  number_integer,
  number_monetary
};

struct item_border
{
  gint                                  m_active;
  enum line_style_type                  m_style;
  gdouble                               m_thickness;
  GdkRGBA                               m_color;
};

struct item_table
{
  char*                                 m_query;
  char*                                 m_column;
};

struct item_fill
{
  int                                   m_active;
  GdkRGBA                               m_color;
};

struct item_transform
{
  double                                m_rotation;
  double                                m_shear_x;
  double                                m_shear_y;
};

extern enum date_style_type
item_common_get_datetime_style(
  char const*                           i_style);

extern char const*
item_common_get_datetime_style_text(
  enum date_style_type const            i_style);

extern enum line_style_type
item_common_get_line_style(
  char const*                           i_style);

extern char const*
item_common_get_line_style_text(
  enum line_style_type const            i_style);

extern enum number_type 
item_common_get_number(
  char const*                           i_type);

extern char const*
item_common_get_number_text(
  enum number_type const                i_type);

extern PangoWrapMode 
item_common_get_wrapmode(
  char const*                           i_mode);

extern char const*
item_common_get_wrapmode_text(
  PangoWrapMode const                   i_mode);

extern void
item_common_lookup(
  int *const                            o_found,
  enum element_tag_type*const           o_type,
  char const*                           i_key);

extern int
item_common_read_border(
  GError**                              o_error,
  struct item_border*const         	    io_border,
  struct xml *const                     i_xml);

extern int
item_common_read_table(
  GError**                              o_error,
  struct item_table*const               io_table, 
  struct xml *const                     i_xml);

extern int
item_common_read_fill(
  GError**                              o_error,
  struct item_fill*const                io_fill,
  struct xml *const                     i_xml);

extern int
item_common_read_transform(
  GError**                              o_error,
  struct item_transform*const           io_transform,
  struct xml *const                     i_xml);

extern int
item_common_write_border(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_border const*const   	    i_border);

extern int
item_common_write_fill(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fill const*const          i_fill);

extern int
item_common_write_table(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_table const*const         i_table);

extern int
item_common_write_transform(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_transform const*const     i_transform);

#define __item_common_attr_h_
#endif
