/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_h__

#include "item_circle.h"
#include "item_date.h"
#include "item_fbarcode.h"
#include "item_fimage.h"
#include "item_fnumber.h"
#include "item_ftext.h"
#include "item_frame.h"
#include "item_image.h"
#include "item_line.h"
#include "item_page_number.h"
#include "item_fsum.h"
#include "item_report.h"
#include "item_text.h"

enum item_type
{
  item_type_circle= element_tag_circle,
  item_type_date= element_tag_date,
  item_type_fbarcode= element_tag_fbarcode,
  item_type_fimage= element_tag_fimage,
  item_type_fnumber= element_tag_fnumber,
  item_type_frame= element_tag_frame,
  item_type_ftext= element_tag_ftext,
  item_type_image= element_tag_image,
  item_type_line= element_tag_line,
  item_type_page_number= element_tag_page_number,
  item_type_fsum= element_tag_fsum,
  item_type_report= element_tag_report,
  item_type_text= element_tag_text
};

struct item_node
{
  enum item_type                        m_type;
  int                                   m_selected;
  union
  {
    struct item_fbarcode                m_fbarcode;
    struct item_circle                  m_circle;
    struct item_date                    m_date;
    struct item_fimage                  m_fimage;
    struct item_fnumber                 m_fnumber;
    struct item_frame                   m_frame;
    struct item_fsum                    m_fsum;
    struct item_ftext                   m_ftext;
    struct item_image                   m_image;
    struct item_line                    m_line;
    struct item_page_number             m_page_number;
    struct item_report                  m_report;
    struct item_text                    m_text;
  }                                     m_object;
  struct item_method                    m_method;
  struct item_node*                     m_next;
  struct item_node*                     m_prev;
};

struct item
{
  struct item_node*                     m_head;
  struct item_node*                     m_tail;
};

extern void
item_assign(
  struct item*const                     o_item);

extern void
item_clear(
  struct item*const                     io_item);

extern void
item_discharge(
  struct item*const                     io_item);

extern void
item_draw(
  struct item*const                     io_item,
  cairo_t*const                         i_cr,
  double const                          i_scale,
  struct item_draw_options const*const  i_option);

extern void
item_deselect_all(
  struct item*const                     io_item);

extern void
item_node_append(
  struct item*const                     io_item,
  struct item_node*const                i_node);

extern int
item_node_in_event(
  struct item_node**                    o_node,
  cairo_t*                              io_cr,
  struct item const*const               i_item,
  struct geom_point const*const         i_event,
  double const                          i_scale);

extern void
item_node_insert_after(
  struct item*const                     io_item,
  struct item_node*const                i_node,
  struct item_node*const                i_node_new);

extern void
item_node_insert_before(
  struct item*const                     io_item,
  struct item_node*const                i_node,
  struct item_node*const                i_node_new);

extern void
item_selected_move(
  struct item*const                     io_item,
  struct geom_point const*const         i_event);

extern void
item_move_to_front(
  struct item*const                     io_item,
  struct item_node*const                io_node);

extern void
item_move_to_back(
  struct item*const                     io_item,
  struct item_node*const                io_node);

extern void
item_move_down(
  struct item*const                     io_item,
  struct item_node*const                io_node);

extern void
item_move_up(
  struct item*const                     io_item,
  struct item_node*const                io_node);

extern void
item_node_get_nth(
  struct item_node**                    o_node,
  struct item*const                     io_item,
  unsigned const                        i_slot);

extern void
item_node_new(
  struct item_node**                    o_node,
  struct item*const                     io_item,
  enum item_type const                  i_type);

extern void
item_node_property(
  struct item_node*const                io_node);

extern void
item_node_remove(
  struct item*const                     io_item,
  struct item_node*                     i_node);

extern void
item_normalize(
  struct item*const                     io_item);

extern int
item_read(
  GError**                              o_error,
  struct item *const                    io_item,
  struct xml *const                     i_xml);

extern void
item_selected_normalize(
  struct item*const                     io_item);

extern void
item_selected_remove(
  struct item*const                     io_item);

extern void
item_selected_resize(
  struct item*const                     io_item,
  struct item_resize_event const*const  i_ctx);

extern void
item_selected_rotate(
  struct item*const                     io_item,
  double const                          i_rotation);

extern void
item_selected_shear(
  struct item*const                     io_item,
  double const                          i_delta_x,
  double const                          i_delta_y);

extern int
item_node_write(
  GError**                              o_error,
  FILE*const                            i_fp,
  struct item const*const               i_item);

extern void
item_node_unlink(
  struct item*const                     io_item,
  struct item_node*                     i_node);

#define __item_h__
#endif
