/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __global_common_h__

#include <glib.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <pango/pangocairo.h>
#include <cairo/cairo-pdf.h>

#include <errno.h>
#include <limits.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "zlib.h"

#include "version.h"
#include "error.h"
#include "xml.h"

#ifndef POINTS_PER_INCH
# define POINTS_PER_INCH 72
#endif

extern GMutex                           g_run_dialog_mutex;
extern char*                            g_builder_dir;
extern char*                            g_database_config_filename;
extern GtkWindow*                       g_main_window;
extern char*                            g_module_filename;

extern char const*
get_database_config_filename();

extern GtkWindow*
get_main_window();

extern int
global_common_create_for_console(
  GError **                             o_error,
  int                                   i_argc, 
  char *                                i_argv[]);

extern int
global_common_create_for_gui(
  GError **                             o_error,
  int                                   i_argc, 
  char *                                i_argv[]);

extern void
global_common_destroy();

extern void
utf8_scrub_kludge(
  char*                                 io_buf);

extern guint
wrap_gtk_builder_add_from_file(
  GtkBuilder *                          io_builder,
  gchar const*                          i_filename,
  GError **                             o_error);

#define get_database_config_filename()  g_database_config_filename
#define get_main_window()               g_main_window

#define __global_common_h__
#endif
