/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __geom_rectvect_h__

#include "geom_rect.h"

enum rectvect_index
{
  top_left_x= 0,
  top_left_y= 1,
  top_right_x= 2,
  top_right_y= 3,
  bottom_right_x= 4,
  bottom_right_y= 5,
  bottom_left_x= 6,
  bottom_left_y= 7,
};

typedef double                          rectvect_t[8];

extern void
geom_rectvect_copy(
  rectvect_t                            o_target,
  rectvect_t const                      i_src);

extern void
geom_rectvect_copy_from_box(
  rectvect_t                            o_rect,
  struct geom_rect const*const          i_box);

extern void
geom_rectvect_get_bounding_box(
  struct geom_rect*const                o_box,
  rectvect_t const                      i_rect);  

extern double
geom_rectvect_get_rotation(
  rectvect_t const                      i_rect);  

extern void
geom_rectvect_rotate(
  rectvect_t                            io_rect,
  double const                          i_degrees);

extern void
geom_rectvect_rotate_around_point(
  rectvect_t                            io_rect,
  double const                          i_degrees,
  double const                          i_origin_x,
  double const                          i_origin_y);

extern void
geom_rectvect_shear_x(
  rectvect_t                            io_rect,
  double const                          i_degrees);

extern void
geom_rectvect_shear_y(
  rectvect_t                            io_rect,
  double const                          i_degrees);

extern void
geom_rectvect_grow(
  rectvect_t                            io_rect,
  double const                          i_delta);

extern void
geom_rectvect_make_square(
  rectvect_t                            i_rect);

#define debug_rectvect(r)\
  printf(\
    "top_left_x=%f top_left_y=%f "\
    "top_right_x=%f top_right_y=%f "\
    "bottom_right_x=%f bottom_right_y=%f "\
    "bottom_left_x=%f bottom_left_y=%f\n", \
    r[0], r[1], r[2], r[3], r[4], r[5], r[6], r[7])

#define __geom_rectvect_h__
#endif
