/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "driver_config.h"

extern void
driver_config_assign(
  struct driver_config*const              o_config)
{

  memset(o_config, 0, sizeof(*o_config));

  return;
}

extern void
driver_config_discharge(
  struct driver_config*const              io_config)
{
  unsigned                                l_slot;

  for (l_slot= 0; (*io_config).m_count > l_slot; l_slot++)
  {
    g_free((*io_config).m_module[l_slot].m_tag);
    g_free((*io_config).m_module[l_slot].m_dll);
  }

  g_free((*io_config).m_module);

  memset(io_config, 0, sizeof(*io_config));

  return;
}

extern int
driver_config_load(
  GError**                              o_error,
  struct driver_config*const            o_config)
{
  static struct driver_module const     l_driver[]=
  {
    {"PostgreSQL",  "libiwsql_pq." G_MODULE_SUFFIX,
      DRIVER_HAS_SHOW_DATABASE},
    {"SQLite",      "libiwsql_sqlite3." G_MODULE_SUFFIX,
      DRIVER_DATABASE_IS_FILE},
    {"MariaDB",     "libiwsql_mariadb." G_MODULE_SUFFIX,
      DRIVER_HAS_SHOW_DATABASE},
    {"Oracle",      "libiwsql_oracle." G_MODULE_SUFFIX, 
      0}
  };
  static unsigned const                 l_driver_slots=
    sizeof(l_driver) / sizeof(l_driver[0]);
  int                                   l_exit;
  unsigned                              l_slot;

  l_exit= 0;

  (*o_config).m_module= (struct driver_module*)
    calloc(l_driver_slots, sizeof(struct driver_module));

  (*o_config).m_count= l_driver_slots;

  for (l_slot= 0; l_driver_slots > l_slot; l_slot++)
  {
    (*o_config).m_module[l_slot].m_tag= g_strdup(l_driver[l_slot].m_tag);
    (*o_config).m_module[l_slot].m_dll= g_strdup(l_driver[l_slot].m_dll);
    (*o_config).m_module[l_slot].m_flags= l_driver[l_slot].m_flags;
  }

  return l_exit;
}

extern struct driver_module const*
driver_config_lookup(
  struct driver_config const*const      i_config,
  char const*                           i_module)
{
  struct driver_module*                 l_module;
  int                                   l_rc;
  unsigned                              l_slot;

  l_module= 0;

  for (l_slot= 0; (*i_config).m_count > l_slot; l_slot++)
  {

    l_rc= strcmp(i_module, (*i_config).m_module[l_slot].m_tag);

    if (0 == l_rc)
    {
      l_module= &(*i_config).m_module[l_slot];
    }
  }

  return l_module;
}
