/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __database_config_h__

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include "global_common.h"
#include "database_aspect.h"

#define DATABASE_CONFIG_DEFAULT_TAG     "aspect"

struct database_config
{
  struct database_aspect*               m_aspect;
  unsigned                              m_count;
};

extern void
database_config_assign(
  struct database_config*const          o_config);

extern void
database_config_discharge(
  struct database_config*const          io_config);

extern void
database_config_load(
  struct database_config*const          o_config);

extern void
database_config_delete_group(
  struct database_config*const          io_config,
  unsigned const                        i_slot);

extern void
database_config_populate_tag(
  char                                  o_tag[31+1],
  struct database_config const*const    i_config);

extern void
database_config_save_aspect(
  struct database_aspect const*const    i_aspect);

#define __database_config_h__
#endif
