/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym.h"


extern void
barsym_code128_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);

  return;
}

extern void
barsym_code39_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height;

  return;
}

extern void
barsym_code93_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height;

  return;
}

extern void
barsym_codabar_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height;

}

extern void
barsym_ean2_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean8_default(io_barsym);

  return;
}

extern void
barsym_ean5_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean8_default(io_barsym);

  return;
}

extern void
barsym_ean8_default(
  struct barsym*const                   io_barsym)
{

  (*io_barsym).m_height= POINTS_PER_INCH * EAN8_HEIGHT;
  (*io_barsym).m_bar_width= POINTS_PER_INCH * (EAN8_XDIMENSION_MM * MM_PER_IN);
  (*io_barsym).m_bar_height= POINTS_PER_INCH * EAN8_BAR_HEIGHT;
  (*io_barsym).m_quiet_zone_left= 7.0 * (*io_barsym).m_bar_width;
  (*io_barsym).m_quiet_zone_right= 7.0 * (*io_barsym).m_bar_width;
  (*io_barsym).m_pos_x= 0.0;
  (*io_barsym).m_pos_y= 0.10 * POINTS_PER_INCH;

  return;
}

extern void
barsym_ean13_default(
  struct barsym*const                   io_barsym)
{

  (*io_barsym).m_height= POINTS_PER_INCH * EAN13_HEIGHT;
  (*io_barsym).m_bar_width= POINTS_PER_INCH * (EAN13_XDIMENSION_MM * MM_PER_IN);
  (*io_barsym).m_bar_height= POINTS_PER_INCH * EAN13_BAR_HEIGHT;
  (*io_barsym).m_quiet_zone_left= 11.0 * (*io_barsym).m_bar_width;
  (*io_barsym).m_quiet_zone_right= 7.0 * (*io_barsym).m_bar_width;
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height + 
    (((*io_barsym).m_height - (*io_barsym).m_bar_height) / 2.0);
  (*io_barsym).m_pos_x= 0.0;
  (*io_barsym).m_pos_y= 0.0;
  (*io_barsym).m_print_text= 1;

  return;
}

extern void
barsym_interleaved2of5_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height;

  return;
}

extern void
barsym_standard2of5_default(
  struct barsym*const                   io_barsym)
{

  barsym_ean13_default(io_barsym);
  (*io_barsym).m_guard_height= (*io_barsym).m_bar_height;

  return;
}
