/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "pg.h"

EXTERN int
iwsql_show_databases(
  char**                                o_error,
  char***                               o_list,
  unsigned*const                        o_slots,
  struct postgres *const                io_pg)
{
  int                                   l_eof;
  int                                   l_exit;
  char**                                l_list;

  (*o_list)= 0;
  (*o_slots)= 0;

  do
  {

    l_exit= iwsql_exec(
      o_error,
      "SELECT datname FROM pg_database WHERE datistemplate=false",
      io_pg);

    if (l_exit)
    {
      break;
    }

    if (0 == (*io_pg).m_tuple_slots)
    {
      break;
    }

    l_list= (char**)malloc((*io_pg).m_tuple_slots*sizeof(char*));

    do
    {

      l_exit= iwsql_next(o_error, &l_eof, io_pg);

      if (l_exit)
      {
        break;
      }

      if (l_eof)
      {
        break;
      }

      l_list[(*io_pg).m_tuple - 1]= (*io_pg).m_attr[0].m_value;
      (*io_pg).m_attr[0].m_value= 0;

    }while(1);

    (*o_list)= l_list;
    (*o_slots)= (*io_pg).m_tuple_slots;

  }while(0);

  return l_exit;
}
