/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "pg.h"

EXTERN void
iwsql_oid_translate(
  enum iwsql_type *const                o_type,
  Oid const                             i_oid)
{
  enum iwsql_type                       l_type;
  
  switch(i_oid)
  {
    case BOOLOID:
    /*
    DESCR("boolean, 'true'/'false'");
    #define BOOLOID			16
    */
      l_type= iwsql_type_bool;
      break;
    case BYTEAOID:
    /*
    DESCR("variable-length string, binary values escaped");
    #define BYTEAOID		17
    */
      l_type= iwsql_type_bytea;
      break;
    case CHAROID:
    /*
    DESCR("single character");
    #define CHAROID			18
    */
      l_type= iwsql_type_char;
      break;
    case INT8OID:
    /*
      DESCR("~18 digit integer, 8-byte storage");
      #define INT8OID			20
    */
      l_type= iwsql_type_longlong;
      break;
    case INT2OID:	
    /*
      DESCR("-32 thousand to 32 thousand, 2-byte storage");
      #define INT2OID			21
    */
      l_type= iwsql_type_short;
      break;
    case INT4OID:
    /*
      DESCR("-2 billion to 2 billion integer, 4-byte storage");
      #define INT4OID			23
    */
      l_type= iwsql_type_long;
      break;
    case TEXTOID:			
    /*
      DESCR("variable-length string, no limit specified");
      #define TEXTOID			25
    */
      l_type= iwsql_type_vchar;
      break;
    default:
      l_type= iwsql_type_unkown;
      break;
  } 

  (*o_type)= l_type;

  return;
}
