/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __orcl_hpp__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <string>
#include <vector>
#include <occi.h>

#include "iwsql.h"

struct orcl
{
  oracle::occi::Environment*            m_env;
  oracle::occi::Connection*             m_conn;
  oracle::occi::Statement*              m_stmt;
  oracle::occi::ResultSet*              m_rs;
  struct iwsql_attr*                    m_attr;
  unsigned                              m_attr_slots;
};

#ifdef __cplusplus
extern "C" {
#endif

extern void 
iwsql_attr_delete(
  struct iwsql_attr**                   o_attr,
  unsigned const                        i_slots);

extern void
iwsql_attr_new(
  struct iwsql_attr**                   o_attr,
  unsigned *const                       o_slots,
  struct orcl*const                     i_oracle);

extern int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct orcl*const                     io_oracle);

extern void
iwsql_delete(
  struct orcl**                         io_oracle);

extern int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct orcl*const                     io_oracle);

extern void
iwsql_new(
  struct orcl**                         o_oracle);

extern int
iwsql_next(
  char**                                o_error,
  int*const                             o_eof,
  struct orcl *const                    io_oracle);

extern void 
iwsql_result(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  struct orcl *const                    i_oracle);

extern int
iwsql_show_databases(
  char**                                o_error,
  char***                               o_list,
  unsigned*const                        o_slots,
  struct orcl *const                    io_oracle);

extern int
iwsql_show_tables(
  char**                                o_error,
  char***                               o_list,
  unsigned*const                        o_slots,
  struct orcl *const                    io_oracle);

extern void
iwsql_type_translate(
  enum iwsql_type *const                o_type,
  oracle::occi::Type const              i_type);

#ifdef __cplusplus
}
#endif

#define __orcl_hpp__
#endif
