/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __mariadb_h__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <mysql.h>
#include "iwsql.h"

#ifdef WIN32
#  ifdef DLL_INTERNAL
#    define EXTERN extern __declspec(dllexport)
#  else
#    define EXTERN extern __declspec(dllimport)
#  endif
#else
#  ifdef __cplusplus
#    define EXTERN extern "C"
#  else
#    define EXTERN extern 
#  endif
#endif

struct mariadb
{
  char*                                 m_database;
  MYSQL*                                m_connection;
  MYSQL_RES*                            m_result;
  unsigned                              m_tuple;
  unsigned                              m_tuple_slots;
  struct iwsql_attr*                    m_attr;
  unsigned                              m_attr_slots;
};

EXTERN void 
iwsql_attr_delete(
  struct iwsql_attr**                   o_attr,
  unsigned const                        i_slots);

EXTERN void
iwsql_attr_new(
  struct iwsql_attr**                   o_attr,
  unsigned *const                       o_slots,
  struct mariadb*const                  i_mysql);

EXTERN int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct mariadb*const                  i_mysql);

EXTERN void
iwsql_delete(
  struct mariadb**                      io_mysql);

EXTERN void
iwsql_error(
  char**                                o_error,
  char const*                           i_message,
  MYSQL*const                           i_connection);

EXTERN int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct mariadb*const                  io_mysql);

EXTERN void
iwsql_new(
  struct mariadb**                      o_mysql);

EXTERN int
iwsql_next(
  char**                                o_error,
  int*const                             o_eof,
  struct mariadb *const                 i_mysql);

EXTERN void 
iwsql_result(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  struct mariadb *const                 i_mysql);

EXTERN int
iwsql_show_databases(
  char**                                o_error,
  char***                               o_list,
  unsigned*const                        o_slots,
  struct mariadb *const                 i_mysql);

EXTERN int
iwsql_show_tables(
  char**                                o_error,
  char***                               o_list,
  unsigned*const                        o_slots,
  struct mariadb *const                 i_mysql);

#define __mariadb_h__
#endif
