/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mariadb.h"

EXTERN int
iwsql_next(
  char**                                o_error,
  int*const                             o_eof,
  struct mariadb *const                 i_mysql)
{
  struct iwsql_attr*                    l_attr;
  int                                   l_exit;
  unsigned long*                        l_lengths;
  MYSQL_ROW                             l_row;
  unsigned                              l_slot;
  char const*                           l_value;

  l_exit= 0;
  (*o_error)= 0;

  do
  {

    l_row= mysql_fetch_row((*i_mysql).m_result);

    if (0 == l_row)
    {
      (*o_eof)= 1;
      break;
    }

    (*o_eof)= 0;

    l_attr= &(*i_mysql).m_attr[0];
    l_lengths= mysql_fetch_lengths((*i_mysql).m_result);

    for(l_slot = 0; l_slot < (*i_mysql).m_attr_slots; l_slot++)
    {

      l_value= (char const*)l_row[l_slot];
      (*l_attr).m_size= l_lengths[l_slot];

      if ((*l_attr).m_value)
      {
        free((*l_attr).m_value);
      }

      if (l_value && (*l_attr).m_size)
      {
        (*l_attr).m_value= (char*)malloc(1+(*l_attr).m_size);
        memset((*l_attr).m_value, 0, 1+(*l_attr).m_size);
        memcpy((*l_attr).m_value, l_value, (*l_attr).m_size);
      }
      else
      {
        (*l_attr).m_value= 0;
      }

      l_attr++;

    }

    (*i_mysql).m_tuple++;

  }while(0);

  return l_exit;
}
