/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mariadb.h"

EXTERN int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct mariadb*const                  io_mysql)
{
  struct iwsql_attr*                    l_attr;
  int                                   l_exit;
  MYSQL_FIELD*                          l_field;
  size_t                                l_size;
  int                                   l_slot;
  char const*                           l_str;

  do
  {

    if ((*io_mysql).m_attr)
    {
      iwsql_attr_delete(&(*io_mysql).m_attr, (*io_mysql).m_attr_slots);
      (*io_mysql).m_attr_slots= 0;
    }

    if ((*io_mysql).m_result)
    {
      mysql_free_result((*io_mysql).m_result);
    }

    l_exit= mysql_real_query(
      (*io_mysql).m_connection,
      i_query,
      strlen(i_query));    

    if (l_exit)
    {
      iwsql_error(o_error, "Unable to prepare statement", (*io_mysql).m_connection);
      l_exit= -1;
      break;
    }

    (*io_mysql).m_result= mysql_use_result((*io_mysql).m_connection);

    (*io_mysql).m_attr_slots= mysql_num_fields((*io_mysql).m_result);

    if (0 == (*io_mysql).m_attr_slots)
    {
      break;
    }

    l_attr= (struct iwsql_attr*)
      calloc((*io_mysql).m_attr_slots, sizeof(struct iwsql_attr));

    memset(l_attr, 0, (*io_mysql).m_attr_slots * sizeof(struct iwsql_attr));

    (*io_mysql).m_attr= l_attr;

    for(l_slot= 0; (*io_mysql).m_attr_slots > l_slot; l_slot++)
    {

      l_field= mysql_fetch_field((*io_mysql).m_result);

      l_str= (*l_field).name;
      l_size= strlen(l_str);
      l_attr[l_slot].m_tag= (char*)malloc(1+l_size);
      memset(l_attr[l_slot].m_tag, 0, 1+l_size);
      memcpy(l_attr[l_slot].m_tag, l_str, l_size);

      switch((*l_field).type)
      {

        case MYSQL_TYPE_TINY:      /* 1 */ 
          l_attr[l_slot].m_type= iwsql_type_char;
          break;
        case MYSQL_TYPE_SHORT:     /* 2 */ 
          l_attr[l_slot].m_type= iwsql_type_short;
          break;
        case MYSQL_TYPE_LONG:      /* 4 */ 
          l_attr[l_slot].m_type= iwsql_type_long;
          break;
        case MYSQL_TYPE_LONGLONG:  /* 8 */ 
          l_attr[l_slot].m_type= iwsql_type_longlong;
          break;
        case MYSQL_TYPE_FLOAT:     /* 4 */
          l_attr[l_slot].m_type= iwsql_type_float;
          break;
        case MYSQL_TYPE_DOUBLE:    /* 8 */
          l_attr[l_slot].m_type= iwsql_type_double;
          break;
        case MYSQL_TYPE_TIME:      /* sizeof(MYSQL_TIME) */
          l_attr[l_slot].m_type= iwsql_type_unkown;
          break;
        case MYSQL_TYPE_DATE:      /* sizeof(MYSQL_TIME) */
          l_attr[l_slot].m_type= iwsql_type_unkown;
          break;
        case MYSQL_TYPE_DATETIME:  /* sizeof(MYSQL_TIME) */
          l_attr[l_slot].m_type= iwsql_type_unkown;
          break;
        case MYSQL_TYPE_STRING:    /* data length */
          l_attr[l_slot].m_type= iwsql_type_bytea;
          break;
        case MYSQL_TYPE_BLOB:      /* data_length */
          l_attr[l_slot].m_type= iwsql_type_blob;
          break;
        case MYSQL_TYPE_VAR_STRING:
          l_attr[l_slot].m_type= iwsql_type_vchar;
          break;
        default:
          l_attr[l_slot].m_type= iwsql_type_unkown;
          break;
      }
    }

  }while(0);

  return l_exit;
}
