/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
#include <gtk/gtk.h>
#include "ruler.h"

static void
margin_changed(Ruler* ruler, gpointer *user)
{
  gdouble left;
  gdouble right;

  ruler_get_margin(ruler, &left, &right);

  printf("margin changed left=%f right=%f\n", left, right);

}

static void
activate (GtkApplication* app,
          gpointer        user_data)
{
  GtkWidget *window;
  Ruler *rulerh; 

  window = gtk_application_window_new (app);
  gtk_window_set_title (GTK_WINDOW (window), "Window");
  gtk_window_set_default_size (GTK_WINDOW (window), 200, 200);

  rulerh= RULER(ruler_new(GTK_ORIENTATION_HORIZONTAL));
  /*rulerh= RULER(ruler_new(GTK_ORIENTATION_VERTICAL));*/
  ruler_set_scale(rulerh, 1.00);
  ruler_set_paper_length(rulerh, 8.5);
  ruler_set_margin(rulerh, 0.25, 0.25);
  gtk_container_add(GTK_WIDGET(window), rulerh);

  g_signal_connect(
    rulerh,
    "margin-changed",
    G_CALLBACK(margin_changed),
    0);

  gtk_widget_show_all (window);
}

int
main (int    argc,
      char **argv)
{
  GtkApplication *app;
  int status;

  app = gtk_application_new ("org.gtk.example", G_APPLICATION_FLAGS_NONE);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);
  status = g_application_run (G_APPLICATION (app), argc, argv);
  g_object_unref (app);

  return status;
}

