/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_property.h"

static void
item_property_get_color(
  GtkEntry*                             io_entry,
  char const*                           i_label)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_dialog= gtk_color_chooser_dialog_new(i_label, get_main_window());
    gtk_color_chooser_set_use_alpha(GTK_COLOR_CHOOSER(l_dialog), 1);

    l_text= gtk_entry_get_text(io_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text(io_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

extern void
item_property_border_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{

  item_property_get_color(GTK_ENTRY(i_data), "Border");
  
  return;
}

extern void
item_property_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{

  item_property_get_color(GTK_ENTRY(i_data), "Color");
  
  return;
}

extern void
item_property_fill_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{

  item_property_get_color(GTK_ENTRY(i_data), "Fill");
  
  return;
}

extern void
item_property_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  GtkEntry*                             l_entry;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_entry= GTK_ENTRY(i_data);

    l_text= gtk_entry_get_text(l_entry);

    l_dialog= gtk_font_chooser_dialog_new("Font", get_main_window());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(l_entry, l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

extern void
item_property_comboboxtext_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct item_table_dialog*             l_dlg;
  unsigned                              l_index;
  char *                                l_query;
  int                                   l_rc;
  unsigned                              l_slot;

  l_query= 0;

  l_dlg= (struct item_table_dialog*)i_data;
  gtk_combo_box_text_remove_all((*l_dlg).m_column_comboboxtext);
  l_query= gtk_combo_box_text_get_active_text((*l_dlg).m_query_comboboxtext);

  do
  {

    if (0 == l_query)
    {
      break;
    }

    for (l_index= 0; g_cache_slots > l_index; l_index++)
    {
      l_rc= g_strcmp0(l_query, g_cache[l_index].m_tag);

      if (0 == l_rc)
      {
        l_slot= 0;

        do
        {

          if (g_cache[l_index].m_attr_slots <= l_slot)
          {
            break; 
          }

          gtk_combo_box_text_append_text(
            (*l_dlg).m_column_comboboxtext,
            g_cache[l_index].m_attr[l_slot].m_tag);
            
          l_slot++;

        }while(1);
        break;
      }
    }

  }while(0);

  g_free(l_query);

  return;
}

extern void
item_property_database_set_active(
  GtkComboBoxText*                      io_query_comboboxtext,
  GtkComboBoxText*                      io_column_comboboxtext,
  struct item_table const*const         i_table)
{
  unsigned                              l_slot;
  unsigned                              l_slot2;
  int                                   l_rc;

  l_slot= 0;

  do
  {

    if (g_cache_slots <= l_slot)
    {
      break;
    }

    l_rc= g_strcmp0(g_cache[l_slot].m_tag, (*i_table).m_query);

    if (0 == l_rc)
    {
      gtk_combo_box_set_active(GTK_COMBO_BOX(io_query_comboboxtext), l_slot);

      l_slot2= 0;
      do
      {

        if (g_cache[l_slot].m_attr_slots <= l_slot2)
        {
          break;
        }

        l_rc= g_strcmp0(
          g_cache[l_slot].m_attr[l_slot2].m_tag, 
          (*i_table).m_column);

        if (0 == l_rc)
        {
          gtk_combo_box_set_active(
            GTK_COMBO_BOX(io_column_comboboxtext),
            l_slot2);
        }

        l_slot2++;

      }while(1);

      break;
    }

    l_slot++;

  }while(1);

  return;
}

extern void
item_property_group_set_active(
  GtkComboBoxText*                      io_group_comboboxtext,
  char const*                           i_group)
{
  struct layout const*                  l_layout;
  int                                   l_rc;
  unsigned                              l_slot;

  do
  {

    if (style_label == (*g_mainw).m_report.m_style)
    {
      gtk_widget_set_sensitive(GTK_WIDGET(io_group_comboboxtext), 0);
      break;
    }

    gtk_widget_set_sensitive(GTK_WIDGET(io_group_comboboxtext), 1);

    if (0 == i_group)
    {
      gtk_combo_box_set_active(GTK_COMBO_BOX(io_group_comboboxtext), -1);
      break;
    }

    l_layout= &(*g_mainw).m_report.m_object.m_layout;

    for (l_slot= 0; (*l_layout).m_group_slots > l_slot; l_slot++)
    {
      l_rc= g_strcmp0((*l_layout).m_group[l_slot].m_break.m_column, i_group);
      if (0 == l_rc)
      {
        gtk_combo_box_set_active(GTK_COMBO_BOX(io_group_comboboxtext), l_slot);
        break;
      }
    }

  }while(0);

  return;
}

extern void
item_property_load_group(
  GtkComboBoxText*                      io_group_comboboxtext)
{
  unsigned                              l_slot;
  struct layout const*                  l_layout;

  do
  {

    if (style_label == (*g_mainw).m_report.m_style)
    {
      gtk_widget_set_sensitive(GTK_WIDGET(io_group_comboboxtext), 0);
      break;
    }

    gtk_widget_set_sensitive(GTK_WIDGET(io_group_comboboxtext), 1);

    l_layout= &(*g_mainw).m_report.m_object.m_layout;

    for (l_slot= 0; (*l_layout).m_group_slots > l_slot; l_slot++)
    {
      gtk_combo_box_text_append_text(
        io_group_comboboxtext,
        (*l_layout).m_group[l_slot].m_break.m_column);
    }

  }while(0);

  return;
}

extern void
item_property_load_query(
  GtkComboBoxText*                      io_query_comboboxtext)
{
  unsigned                              l_slot;

  l_slot= 0;

  if (0 == g_cache)
  {
    database_field_create_cache(
      &(*g_mainw).m_report.m_aspect,
      &(*g_mainw).m_report.m_query);
  }

  do
  {

    if (g_cache_slots <= l_slot)
    {
      break;
    } 

    gtk_combo_box_text_append_text(
      io_query_comboboxtext,
      g_cache[l_slot].m_tag);

    l_slot++;

  }while(1);

  return;
}

