/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym_code128.h"

extern int
barsym_code128(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_center;
  long                                  l_checksum;
  unsigned                              l_digit1;
  unsigned                              l_digit2;
  char const*                           l_encode;
  int                                   l_exit;
  cairo_text_extents_t                  l_extent;
  unsigned char*                        l_filter;
  int                                   l_flags;
  unsigned                              l_left;
  unsigned                              l_position;
  unsigned char const*                  l_ptr;
  enum code128_set_type                 l_startcode;
  enum code128_sub_type                 l_subcode;
  unsigned                              l_value;

  l_checksum= 0;
  l_exit= 0;
  l_left= i_length;
  l_position= 0;
  l_ptr= i_buffer;    

  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_left;

  do
  {

    if ((0 == i_buffer) || (0 == l_left))
    {
      break;
    }

    l_startcode= code_start_b;
    l_subcode= code_sub_b;

    if (CODE_128_FNC1 == l_ptr[0] ||
      (4 >= l_left && 
      isdigit(l_ptr[0]) && 
      isdigit(l_ptr[1]) &&
      isdigit(l_ptr[2]) &&
      isdigit(l_ptr[3])))
    {
      l_startcode= code_start_c;
      l_subcode= code_sub_c;
    }
    else if (0x20 > l_ptr[0])
    {
      l_startcode= code_start_a;
      l_subcode= code_sub_a;
    }
  
    l_checksum= (long)l_startcode;

    l_encode= g_code128_encode[l_startcode];
    barsym_write_bar(io_barsym, l_encode, BARSYM_GUARD);

    if (CODE_128_FNC1 == l_ptr[0])
    {
      l_encode= g_code128_encode[code_fnc1];
      barsym_write_bar(io_barsym, l_encode, 0);

      l_left--;
      l_ptr++;
      l_position++;
      l_checksum+= (l_position * code_fnc1);
    }

    do
    {

      if (0 == l_left)
      {
        break;
      }


      if (code_sub_c == l_subcode)
      {
        if (2 > l_left || !isdigit(l_ptr[0]) || !isdigit(l_ptr[1]))
        {
          l_subcode= ((code_start_a == l_startcode) ? code_sub_a : code_sub_b);
          l_encode= g_code128_encode[l_subcode];
          barsym_write_bar(io_barsym, l_encode, 0);
          l_position++;
          l_checksum+= (l_position * l_subcode);
        }
        else
        {
          l_digit1= (l_ptr[0] - 0x30) * 10;
          l_digit2= (l_ptr[1] - 0x30);
          l_value= l_digit1 | l_digit2;
          l_encode= g_code128_encode[l_value];
          barsym_write_bar(io_barsym, l_encode, 0);
          l_left--;
          l_left--;
          l_ptr++;
          l_ptr++;
          l_position++;
          l_checksum+= (l_position * l_value);
          continue;
        }
      }

      if (4 >= l_left && 
        isdigit(l_ptr[0]) && 
        isdigit(l_ptr[1]) &&
        isdigit(l_ptr[2]) &&
        isdigit(l_ptr[3]))
      {
        l_subcode= code_sub_c;
        l_encode= g_code128_encode[code_sub_c];
        barsym_write_bar(io_barsym, l_encode, 0);
        l_position++;
        l_checksum+= (l_position * code_sub_c);
        continue;
      }

      /* TODO: encode ASCII 128-255 (FNC4) */

      l_value= barsym_code128ab_get_value(&l_flags, (*l_ptr));

      if (0 == ((CODE_128A_FLAG | CODE_128B_FLAG) & l_flags))
      {
        if (CODE_128A_FLAG & l_flags)
        {
          if (code_sub_a != l_subcode)
          {
            l_subcode= code_sub_b;
            l_encode= g_code128_encode[code_sub_b];
            barsym_write_bar(io_barsym, l_encode, 0);
            l_position++;
            l_checksum+= (l_position * code_sub_b);
          }
        }
        else if (code_sub_b != l_subcode)
        {
          l_subcode= code_sub_a;
          l_encode= g_code128_encode[code_sub_a];
          barsym_write_bar(io_barsym, l_encode, 0);
          l_position++;
          l_checksum+= (l_position * code_sub_a);
        }
      }

      l_encode= g_code128_encode[l_value];
      barsym_write_bar(io_barsym, l_encode, 0);

      l_left--;
      l_ptr++;
      l_position++;
      l_checksum+= (l_position * l_value);

    }while(1);

    l_value= l_checksum % 103;

    l_encode= g_code128_encode[l_value];
    barsym_write_bar(io_barsym, l_encode, 0);
    
    l_encode= g_code128_encode[code_stop];
    barsym_write_bar(io_barsym, l_encode, BARSYM_GUARD);

    l_filter= barsym_filter(i_buffer, i_length);
    cairo_text_extents((*io_barsym).m_cr, (char*)l_filter, &l_extent);
    l_center= ((*io_barsym).m_pos_x / 2.0) - (l_extent.width / 2.0);

    cairo_move_to((*io_barsym).m_cr, l_center, (*io_barsym).m_height);
    cairo_show_text((*io_barsym).m_cr, (char*)l_filter);
    free(l_filter);

    (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_right;

  }while(0);

  return l_exit;
}

extern double
barsym_code128_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_width;

  l_width= (*io_barsym).m_quiet_zone_left;
  l_width+= (*io_barsym).m_quiet_zone_right;
  l_width+= ((11 * i_length + 35) * (*io_barsym).m_bar_width);

  return l_width;
}

extern int
barsym_code128_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  int                                   l_exit;
  int                                   l_flags;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;
  int                                   l_value;

  l_exit= 0;
  l_ptr= i_buffer;
  l_slot= 0;

  if (i_length && CODE_128_FNC1 == *l_ptr)
  {
    l_ptr++;
    l_slot++;
  }

  do
  {

    if (i_length <= l_slot)
    {
      break;
    }

    l_value= barsym_code128ab_get_value(&l_flags, *l_ptr);

    if (-1 == l_value)
    {
      l_exit= -1;
      break;
    }

    l_ptr++;
    l_slot++;

  }while(1);

  return l_exit;
}
