/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __sql_h__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sqlite3.h"

#include "iwsql.h"

struct sqlite
{
  sqlite3*                              m_connection;
  sqlite3_stmt*                         m_result;
  struct iwsql_attr*                    m_attr;
  unsigned                              m_attr_slots;
};

#ifdef __cplusplus
extern "C" {
#endif

extern void 
iwsql_attr_delete(
  struct iwsql_attr**                   o_attr,
  unsigned const                        i_slots);

extern void
iwsql_attr_new(
  struct iwsql_attr**                   o_attr,
  unsigned *const                       o_slots,
  struct sqlite*const                   i_sql);

extern int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct sqlite*const                   i_sql);

extern void
iwsql_delete(
  struct sqlite**                       io_sql);

extern void
iwsql_error_code(
  char**                                o_error,
  char const*                           i_message,
  int const                             i_code);

extern int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct sqlite*const                   io_sql);

extern void
iwsql_new(
  struct sqlite**                       o_sql);

extern int
iwsql_next(
  char**                                o_error,
  int*const                             o_eof,
  struct sqlite *const                  i_sql);

extern void 
iwsql_result(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  struct sqlite *const                  i_sql);

#ifdef __cplusplus
}
#endif

#define __sql_h__
#endif
