/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "sqlite.h"

extern int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct sqlite*const                   io_sql)
{
  struct iwsql_attr*                    l_attr;
  int                                   l_exit;
  size_t                                l_size;
  int                                   l_oid;
  int                                   l_slot;
  char const*                           l_str;

  do
  {

    if ((*io_sql).m_attr)
    {
      iwsql_attr_delete(&(*io_sql).m_attr, (*io_sql).m_attr_slots);
      (*io_sql).m_attr_slots= 0;
    }

    if ((*io_sql).m_result)
    {
      sqlite3_finalize((*io_sql).m_result);
    }

    l_exit= sqlite3_prepare_v2(
      (*io_sql).m_connection,
      i_query,
      -1,
      &(*io_sql).m_result,
      0);

    if (SQLITE_OK != l_exit)
    {
      iwsql_error_code(o_error, "Unable to prepare statement", l_exit);
      l_exit= -1;
      break;
    }

    (*io_sql).m_attr_slots= sqlite3_column_count((*io_sql).m_result);
  
    if (0 == (*io_sql).m_attr_slots)
    {
      break;
    }

    l_attr= (struct iwsql_attr*)
      calloc((*io_sql).m_attr_slots, sizeof(struct iwsql_attr));

    memset(l_attr, 0, (*io_sql).m_attr_slots * sizeof(struct iwsql_attr));

    (*io_sql).m_attr= l_attr;

    for(l_slot= 0; (*io_sql).m_attr_slots > l_slot; l_slot++)
    {

      l_str= sqlite3_column_name((*io_sql).m_result, l_slot);
      l_size= strlen(l_str);
      l_attr[l_slot].m_tag= (char*)malloc(1+l_size);
      memset(l_attr[l_slot].m_tag, 0, 1+l_size);
      memcpy(l_attr[l_slot].m_tag, l_str, l_size);
      l_oid= sqlite3_column_type((*io_sql).m_result, l_slot);

      switch(l_oid)
      {
        case SQLITE_INTEGER:
          l_attr[l_slot].m_type= iwsql_type_longlong;
          break;
        case SQLITE_FLOAT:
          l_attr[l_slot].m_type= iwsql_type_double;
          break;
        case SQLITE_BLOB:
          l_attr[l_slot].m_type= iwsql_type_blob;
          break;
        case SQLITE_NULL:
          l_attr[l_slot].m_type= iwsql_type_null;
          break;
        case SQLITE_TEXT:
          l_attr[l_slot].m_type= iwsql_type_bytea;
          break;
        default:
          l_attr[l_slot].m_type= iwsql_type_unkown;
          break;
      }

    }

  }while(0);

  return l_exit;
}
