/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "pg.h"

extern "C" int
iwsql_exec(
  char**                                o_error,
  char const*                           i_query,
  struct postgres*const                 i_pg)
{
  struct iwsql_attr*                    l_attr;
  char const*                           l_emsg;
  ExecStatusType                        l_etype;
  int                                   l_exit;
  Oid                                   l_oid;
  size_t                                l_size;
  unsigned                              l_slot;
  char const*                           l_str;

  l_exit= 0;
  (*o_error)= 0;

  do
  {

    if ((*i_pg).m_attr)
    {
      iwsql_attr_delete(&(*i_pg).m_attr, (*i_pg).m_attr_slots);
      (*i_pg).m_attr_slots= 0;
    }

    if ((*i_pg).m_result)
    {
      PQclear((*i_pg).m_result);
    }

    (*i_pg).m_tuple= 0;
    (*i_pg).m_tuple_slots= 0;

    if ((*i_pg).m_attr_slots)
    {
      iwsql_attr_delete(&(*i_pg).m_attr, (*i_pg).m_attr_slots);
      (*i_pg).m_attr_slots= 0;
    }

    (*i_pg).m_result= PQexec((*i_pg).m_connection, i_query);

    l_etype= PQresultStatus((*i_pg).m_result);

    if (PGRES_TUPLES_OK != l_etype)
    {
      switch(l_etype)
      {
        case PGRES_EMPTY_QUERY:
          l_emsg= "The string sent to the server was empty.";
        case PGRES_COMMAND_OK:
          l_emsg= "Successful completion of a command returning no data.";
        case PGRES_COPY_OUT:
          l_emsg= "Copy Out (from server) data transfer started.";
        case PGRES_COPY_IN:
          l_emsg= "Copy In (to server) data transfer started.";
        case PGRES_BAD_RESPONSE:
          l_emsg= "The server's response was not understood.";
        case PGRES_NONFATAL_ERROR:
          l_emsg= "A nonfatal error (a notice or warning) occurred.";
        case PGRES_FATAL_ERROR:
          l_emsg= "A fatal error occurred.";
        default:
          l_emsg= "Unknown.";
      }
      iwsql_error(o_error, l_emsg, (*i_pg).m_connection);
      l_exit= -1;
      break;
    }

    (*i_pg).m_tuple_slots= PQntuples((*i_pg).m_result);

    (*i_pg).m_attr_slots= PQnfields((*i_pg).m_result);

    if (0 == (*i_pg).m_attr_slots)
    {
      break;
    }

    l_attr= (struct iwsql_attr*)
      calloc((*i_pg).m_attr_slots, sizeof(struct iwsql_attr));

    memset(l_attr, 0, (*i_pg).m_attr_slots * sizeof(struct iwsql_attr));

    (*i_pg).m_attr= l_attr;

    for(l_slot= 0; (*i_pg).m_attr_slots > l_slot; l_slot++)
    {
      l_str= PQfname((*i_pg).m_result, l_slot);
      l_size= strlen(l_str);
      l_attr[l_slot].m_tag= (char*)malloc(1+l_size);
      memset(l_attr[l_slot].m_tag, 0, 1+l_size);
      memcpy(l_attr[l_slot].m_tag, l_str, l_size);
      l_oid= PQftype((*i_pg).m_result, l_slot);
      iwsql_oid_translate(&l_attr[l_slot].m_type, l_oid);
    }

  }while(0);

  return l_exit;
}
