/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "pg.h"

#define DBNAME                          0
#define HOST                            1
#define HOSTADDR                        2
#define PORT                            3
#define USER                            4
#define PASSWORD                        5
#define END                             6
#define PARMS                           7

extern "C" int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct postgres*const                 i_pg)
{
  PGconn*                               l_connection;
  int                                   l_exit;
  char const*                           l_keys[PARMS];
  ConnStatusType                        l_status;
  char const*                           l_values[PARMS];

  (*o_error)= 0;
  l_exit= 0;

  do
  {

    l_keys[DBNAME]= "dbname";
    l_keys[HOST]= "host";
    l_keys[HOSTADDR]= "hostaddr";
    l_keys[PORT]= "port";
    l_keys[USER]= "user";
    l_keys[PASSWORD]= "password";
    l_keys[END]= 0;

    l_values[DBNAME]= (*i_aspect).m_dbname;
    l_values[HOST]= (*i_aspect).m_host;
    l_values[HOSTADDR]= (*i_aspect).m_hostaddr;
    l_values[PORT]= (*i_aspect).m_port;
    l_values[USER]= (*i_aspect).m_username;
    l_values[PASSWORD]= (*i_aspect).m_password;
    l_values[END]= 0;

    l_connection= PQconnectdbParams(l_keys, l_values, 0);

    l_status= PQstatus(l_connection);

    if (CONNECTION_OK != l_status)
    {
      iwsql_error(o_error, "Connection to database failed", l_connection);
      l_exit= -1;
      break;
    }

    (*i_pg).m_connection= l_connection;

  }while(0);

  return l_exit;
}
