/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mariadb.h"

extern int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct mariadb*const                  i_mysql)
{
  int                                   l_exit;
  MYSQL*                                l_mysql;
  unsigned long                         l_port;
  MYSQL*                                l_ptr;

  (*o_error)= 0;
  l_exit= 0;

  do
  {

    l_mysql= mysql_init(0);
    mysql_options(l_mysql, MYSQL_READ_DEFAULT_GROUP, "iwrite");

    l_port= strtoul((*i_aspect).m_port, 0, 10);

    l_ptr= mysql_real_connect(
      l_mysql,
      (*i_aspect).m_host,
      (*i_aspect).m_username,
      (*i_aspect).m_password,
      (*i_aspect).m_dbname,
      l_port,
      0,
      0);

    if (0 == l_ptr)
    {
      iwsql_error(o_error, "Connection to database failed", l_mysql);
      mysql_close(l_mysql);
      l_exit= -1;
      break;
    }
      
    (*i_mysql).m_connection= l_mysql;

  }while(0);

  return l_exit;
}
