/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "rw.h"

extern void
rw_assign(
  struct rw*                            o_rw)
{

  memset(o_rw, 0, sizeof(*o_rw));
  (*o_rw).m_page_number= 1;
  (*o_rw).m_time= time(0);
  query_exec_assign(&(*o_rw).m_exec);

  return;
}

extern void
rw_attr_lookup_by_name(
  struct iwsql_attr const**             o_attr,
  struct query_exec const*const         i_exec,
  char const*                           i_table,
  char const*                           i_field)
{
  struct query_exec_node const*         l_query;

  (*o_attr)= 0;

  do
  {

    query_exec_lookup(&l_query, i_table, i_exec);

    if (0 == l_query)
    {
      break;
    }

    query_exec_node_lookup(o_attr, i_field, l_query);

  }while(0);

  return;
}

extern int
rw_cairo_pdf_surface_create(
  GError**                              o_error,
  struct rw*                            io_rw,
  double const                          i_page_width,
  double const                          i_page_height,
  char const*                           i_outfile)
{
  GError*                               l_error;
  int                                   l_exit;
  cairo_status_t                        l_status;

  l_error= 0;
  l_exit= 0;

  do
  {

    (*io_rw).m_surface= cairo_pdf_surface_create(
      i_outfile,
      i_page_width,
      i_page_height);

    l_status= cairo_surface_status((*io_rw).m_surface);

    if (CAIRO_STATUS_SUCCESS != l_status)
    {
      l_error= g_error_new(
        RW, 
        RW_CREATE_SURFACE,
        "Unable to create cairo surface: file='%s' status(%d)",
        i_outfile,
        l_status);
      _error_log(l_error);
      l_exit= -1;
      break;
    }

    (*io_rw).m_cr= cairo_create((*io_rw).m_surface);

  }while(0);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
rw_discharge(
  struct rw*                            io_rw)
{

  query_exec_discharge(&(*io_rw).m_exec);

  if ((*io_rw).m_cr)
  {
    cairo_destroy((*io_rw).m_cr);
  }

  if ((*io_rw).m_surface)
  {
    cairo_surface_destroy((*io_rw).m_surface);
  }

  memset(io_rw, 0, sizeof(*io_rw));

  return;
}

static void
rw_fbarcode_set_value(
  struct item_fbarcode*                 io_fbarcode,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char                                  l_buf[1+FIELD_NAME_MAX_LEN];
  char*                                 l_table;
  char*                                 l_field;
  char*                                 l_ptr;

  do
  {

    if ((*io_fbarcode).m_value)
    {
      g_free((*io_fbarcode).m_value);
      (*io_fbarcode).m_value= 0;
      (*io_fbarcode).m_value_size= 0;
    }

    memset(l_buf, 0, sizeof(l_buf));
    g_strlcpy(l_buf, (*io_fbarcode).m_tag, sizeof(l_buf));
    l_ptr= strchr(l_buf, '.');

    if (0 == l_ptr)
    {
      l_table= "primary";
      l_field= l_buf;
    } 
    else
    {
      (*l_ptr)= 0;
      l_table= l_buf;
      l_field= l_ptr+1;
    }

    rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);

    if (0 == l_attr)
    {
      break;
    }

    (*io_fbarcode).m_value= g_malloc0((*l_attr).m_size);
    memcpy((*io_fbarcode).m_value, (*l_attr).m_value, (*l_attr).m_size);
    (*io_fbarcode).m_value_size= (*l_attr).m_size;

  }while(0);

  return;
}

static void
rw_sum_set_value(
  struct item_fsum*const                io_sum,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char                                  l_buf[1+FIELD_NAME_MAX_LEN];
  char*                                 l_field;
  char*                                 l_ptr;
  char*                                 l_table;
  decNumber                             l_value;

  memset(&l_value, 0, sizeof(l_value));

  do
  {

    memset(l_buf, 0, sizeof(l_buf));
    g_strlcpy(l_buf, (*io_sum).m_tag, sizeof(l_buf));
    l_ptr= strchr(l_buf, '.');

    if (0 == l_ptr)
    {
      l_table= "primary";
      l_field= l_buf;
    } 
    else
    {
      (*l_ptr)= 0;
      l_table= l_buf;
      l_field= l_ptr+1;
    }

    rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);

    if (0 == l_attr)
    {
      break;
    }

    decNumberFromString(&l_value, (*l_attr).m_value, &(*io_sum).m_ctx);
    decNumberAdd(
      &(*io_sum).m_accumulator, 
      &(*io_sum).m_accumulator, 
      &l_value,
      &(*io_sum).m_ctx);

  }while(0);

  return;
}

static void
rw_fimage_set_value(
  struct item_fimage*                   io_fimage,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char                                  l_buf[1+FIELD_NAME_MAX_LEN];
  char*                                 l_table;
  char*                                 l_field;
  char*                                 l_ptr;

  do
  {

    if ((*io_fimage).m_value)
    {
      g_free((*io_fimage).m_value);
      (*io_fimage).m_value= 0;
      (*io_fimage).m_value_size= 0;
    }

    memset(l_buf, 0, sizeof(l_buf));
    g_strlcpy(l_buf, (*io_fimage).m_tag, sizeof(l_buf));
    l_ptr= strchr(l_buf, '.');

    if (0 == l_ptr)
    {
      l_table= "primary";
      l_field= l_buf;
    } 
    else
    {
      (*l_ptr)= 0;
      l_table= l_buf;
      l_field= l_ptr+1;
    }

    rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);

    if (0 == l_attr)
    {
      break;
    }

    (*io_fimage).m_value= g_malloc0((*l_attr).m_size);
    memcpy((*io_fimage).m_value, (*l_attr).m_value, (*l_attr).m_size);
    (*io_fimage).m_value_size= (*l_attr).m_size;

  }while(0);

  return;
}

static void
rw_fnumber_set_value(
  struct item_fnumber*                  io_fnumber,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char                                  l_buf[1+FIELD_NAME_MAX_LEN];
  char*                                 l_table;
  char*                                 l_field;
  char*                                 l_ptr;

  do
  {

    if ((*io_fnumber).m_value)
    {
      g_free((*io_fnumber).m_value);
      (*io_fnumber).m_value= 0;
    }

    memset(l_buf, 0, sizeof(l_buf));
    g_strlcpy(l_buf, (*io_fnumber).m_tag, sizeof(l_buf));
    l_ptr= strchr(l_buf, '.');

    if (0 == l_ptr)
    {
      l_table= "primary";
      l_field= l_buf;
    } 
    else
    {
      (*l_ptr)= 0;
      l_table= l_buf;
      l_field= l_ptr+1;
    }

    rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);

    if (0 == l_attr)
    {
      break;
    }

    (*io_fnumber).m_value= g_strdup((*l_attr).m_value);

  }while(0);

  return;
}

static void
rw_ftext_set_value(
  struct item_ftext*                    io_ftext,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char                                  l_buf[1+FIELD_NAME_MAX_LEN];
  char*                                 l_table;
  char*                                 l_field;
  char*                                 l_ptr;

  do
  {

    if ((*io_ftext).m_value)
    {
      g_free((*io_ftext).m_value);
      (*io_ftext).m_value= 0;
    }

    memset(l_buf, 0, sizeof(l_buf));
    g_strlcpy(l_buf, (*io_ftext).m_tag, sizeof(l_buf));
    l_ptr= strchr(l_buf, '.');

    if (0 == l_ptr)
    {
      l_table= "primary";
      l_field= l_buf;
    } 
    else
    {
      (*l_ptr)= 0;
      l_table= l_buf;
      l_field= l_ptr+1;
    }

    rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);

    if (0 == l_attr)
    {
      break;
    }

    (*io_ftext).m_value= g_strdup((*l_attr).m_value);

  }while(0);

  return;
}

/*
 * ':{'[table'.']field'}'
 * escape '::{' results in ':{'
 */
static void
rw_text_set_value(
  struct item_text*                     io_text,
  struct query_exec*const               io_exec)
{
  struct iwsql_attr const*              l_attr;
  char*                                 l_buf;
  char*                                 l_field;
  FILE*                                 l_fp;
  FILE*                                 l_fp2;
  char*                                 l_ptr;
  size_t                                l_size;
  char*                                 l_table;
  char*                                 l_tail;

  l_fp= tmpfile();

  do
  {

    if ((*io_text).m_value)
    {
      g_free((*io_text).m_value);
      (*io_text).m_value= 0;
    }

    if (0 == l_fp)
    {
      break;
    }

    l_tail= (*io_text).m_text;

    if (0 == l_tail)
    {
      break;
    }

    do
    {

      if (0 == l_tail[0])
      {
        break;
      }

      if (':' != l_tail[0])
      {
rw_text_fill_store:
        fwrite(l_tail, 1, 1, l_fp);
        l_tail++;
        continue;
      }

      l_tail++;

      if ((':' == l_tail[0]) && ('{' == l_tail[1]))
      {
        goto rw_text_fill_store;
      }

      if ('{' != l_tail[0])
      {
        goto rw_text_fill_store;
      }

      l_tail++;
      l_fp2= tmpfile();

      do  
      {

        if (0 == l_tail[0])
        {
          break;
        }

        if ('}' == l_tail[0])
        {
          break;
        }

        fwrite(l_tail, 1, 1, l_fp2);
        l_tail++;

      }while(1);

      l_size= ftell(l_fp2);
      l_buf= (char*)g_malloc0(1+l_size);
      fseek(l_fp2, 0, SEEK_SET);
      fread(l_buf, l_size, 1, l_fp2);
      fclose(l_fp2);
      l_ptr= strchr(l_buf, '.');

      if (0 == l_ptr)
      {
        l_table= "primary";
        l_field= l_buf;
      } 
      else
      {
        (*l_ptr)= 0;
        l_table= l_buf;
        l_field= l_ptr+1;
      }

      rw_attr_lookup_by_name(&l_attr, io_exec, l_table, l_field);
      g_free(l_buf);
      l_buf= 0;

      if (l_attr && (*l_attr).m_value)
      {
        l_size= strlen((*l_attr).m_value);
        fwrite((*l_attr).m_value, l_size, 1, l_fp);
      }

      l_tail++;

    }while(1);

    l_size= ftell(l_fp);
    l_buf= (char*)g_malloc0(1+l_size);
    fseek(l_fp, 0, SEEK_SET);
    fread(l_buf, l_size, 1, l_fp);
    (*io_text).m_value= l_buf;
    l_buf= 0;

  }while(0);

  if (l_fp)
  {
    fclose(l_fp);
  }

  return;
}

static void
rw_date_set_value(
  struct item_date*const                io_date,
  struct rw*const                       io_rw)
{

  (*io_date).m_time= (*io_rw).m_time;

  return;
}

static void
rw_page_number_set_value(
  struct item_page_number*const         io_page_number,
  struct rw*const                       io_rw)
{

  (*io_page_number).m_page_number= (*io_rw).m_page_number;

  return;
}

extern void
rw_item_clear_accumulator(
  struct item*const                     io_item)
{
  struct item_node*                     l_node;

  do
  {

    if (0 == io_item || 0 == (*io_item).m_head)
    {
      break;
    }

    l_node= (*io_item).m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      if (item_type_fsum == (*l_node).m_type)
      {

        memset(
          &(*l_node).m_object.m_fsum.m_accumulator,
          0,
          sizeof((*l_node).m_object.m_fsum.m_accumulator));

        decNumberFromString(
          &(*l_node).m_object.m_fsum.m_accumulator,
          "0.0",
          &(*l_node).m_object.m_fsum.m_ctx);

      }

      l_node= (*l_node).m_next;

    }while(1);

  }while(0);

  return;
}

extern void
rw_item_set_value(
  struct item*const                     io_item,
  struct rw*const                       io_rw)
{
  struct item_node*                     l_node;

  do
  {

    if (0 == io_item || 0 == (*io_item).m_head)
    {
      break;
    }

    l_node= (*io_item).m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      switch((*l_node).m_type)
      {
        case item_type_fbarcode:
          rw_fbarcode_set_value(&(*l_node).m_object.m_fbarcode, &(*io_rw).m_exec);
          break;
        case item_type_fsum:
          rw_sum_set_value(&(*l_node).m_object.m_fsum, &(*io_rw).m_exec);
          break;
        case item_type_fimage:
          rw_fimage_set_value(&(*l_node).m_object.m_fimage, &(*io_rw).m_exec);
          break;
        case item_type_ftext:
          rw_ftext_set_value(&(*l_node).m_object.m_ftext, &(*io_rw).m_exec);
          break;
        case item_type_fnumber:
          rw_fnumber_set_value(&(*l_node).m_object.m_fnumber, &(*io_rw).m_exec);
          break;
        case item_type_text:
          rw_text_set_value(&(*l_node).m_object.m_text, &(*io_rw).m_exec);
          break;
        case item_type_page_number:
          rw_page_number_set_value(&(*l_node).m_object.m_page_number, io_rw);
          break;
        case item_type_date:
          rw_date_set_value(&(*l_node).m_object.m_date, io_rw);
          break;
        default:
          break;
      }

      l_node= (*l_node).m_next;

    }while(1);

  }while(0);

  return;
}

extern void
rw_layout_clear_accumulator(
  struct layout_spec*const              io_layout)
{
  unsigned                              l_slot;

  rw_item_clear_accumulator((*io_layout).m_cover.m_header.m_item);
  rw_item_clear_accumulator((*io_layout).m_cover.m_footer.m_item);
  rw_item_clear_accumulator((*io_layout).m_report.m_header.m_item);
  rw_item_clear_accumulator((*io_layout).m_report.m_detail.m_item);
  rw_item_clear_accumulator((*io_layout).m_report.m_footer.m_item);

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    g_free((*io_layout).m_group[l_slot].m_break.m_value);
    (*io_layout).m_group[l_slot].m_break.m_value= 0;
    rw_item_clear_accumulator((*io_layout).m_group[l_slot].m_header.m_item);
    rw_item_clear_accumulator((*io_layout).m_group[l_slot].m_footer.m_item);
  }

  return;
}

extern void
rw_level_break_set_value(
  struct layout_spec*const              io_layout,
  struct rw *const                      i_rw)
{
  struct iwsql_attr const*              l_attr;
  struct layout_spec_division_group*    l_group;
  unsigned                              l_slot;

  l_attr= 0;

  if ((*io_layout).m_page_break.m_value)
  {
    g_free((*io_layout).m_page_break.m_value);
    (*io_layout).m_page_break.m_value= 0;
  }

  if ((*io_layout).m_page_break.m_tag && (*io_layout).m_page_break.m_tag[0])
  {
    rw_attr_lookup_by_name(
      &l_attr,
      &(*i_rw).m_exec,
      "primary",
      (*io_layout).m_page_break.m_tag);

    if (l_attr)
    {
      (*io_layout).m_page_break.m_value= g_strdup((*l_attr).m_value);
    }
  }

  for(
    l_group= &(*io_layout).m_group[0], 
    l_slot= 0; 
    (*io_layout).m_group_slots > l_slot; 
    l_slot++,
    l_group++)
  {

    l_attr= 0;
    rw_attr_lookup_by_name(
      &l_attr,
      &(*i_rw).m_exec,
      "primary",
      (*l_group).m_break.m_tag);

    if ((*l_group).m_break.m_value)
    {
      g_free((*l_group).m_break.m_value);
      (*l_group).m_break.m_value= 0;
    }

    if (l_attr)
    {
      (*l_group).m_break.m_value= g_strdup((*l_attr).m_value);
    }

  }

  return;
}


extern void
rw_layout_group_set_value(
  struct layout_spec*const              io_layout,
  struct rw*const                       io_rw)
{
  unsigned                              l_slot;
  struct layout_spec_division_group*    l_group;

  l_group= &(*io_layout).m_group[0];

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    rw_item_set_value((*l_group).m_header.m_item, io_rw);
    rw_item_set_value((*l_group).m_footer.m_item, io_rw);
    l_group++;
  }

  return;
}

extern void
rw_layout_set_fence(
  struct rw*const                       io_rw,
  struct layout_spec*const              io_layout)
{

  (*io_rw).m_fence_bottom= 
    ((*io_layout).m_paper.m_height - (*io_layout).m_paper.m_margin_bottom);

  do
  {
    if (0 == (*io_layout).m_report.m_footer.m_item ||
      0 == (*io_layout).m_report.m_footer.m_item->m_head)
    {
      break;
    }

    (*io_rw).m_fence_bottom= 
      (*io_layout).m_paper.m_height - 
      (*io_layout).m_report.m_footer.m_paper.m_height;

  }while(0);

  return;
}


