/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "page_setup.h"

extern void
page_setup_get_dimension_pt(
  double*const                          o_width,
  double*const                          o_height,
  GtkPageSetup const*const              i_page_setup)
{

  (*o_width)= gtk_page_setup_get_paper_width((GtkPageSetup*)i_page_setup, GTK_UNIT_POINTS);
  (*o_height)= gtk_page_setup_get_paper_height((GtkPageSetup*)i_page_setup, GTK_UNIT_POINTS);

  return;
}

extern int
page_setup_read(
  GError**                              o_error,
  GtkPageSetup*const                    io_page_setup,
  char const*                           i_configfile)
{
  GError*                               l_error;
  int                                   l_exit;
  gboolean                              l_rc;

  l_error= 0;
  l_exit= 0;
  l_rc= gtk_page_setup_load_file(io_page_setup, i_configfile, &l_error);

  if (0 == l_rc)
  {
    _error_log(l_error);
    g_propagate_error(o_error, l_error);
    l_exit= -1;
  }

  return l_exit;
}

extern int
page_setup_write(
  GError**                              o_error,
  char const*                           i_configfile,
  GtkPageSetup const*const              i_page_setup)
{
  GError*                               l_error;
  int                                   l_exit;
  gboolean                              l_rc;

  l_error= 0;
  l_exit= 0;

  l_rc= gtk_page_setup_to_file((GtkPageSetup*)i_page_setup, i_configfile, &l_error);

  if (0 == l_rc)
  {
    _error_log(l_error);
    g_propagate_error(o_error, l_error);
    l_exit= -1;
  }

  return l_exit;
}
