/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __label_spec_h__

#include "global_common.h"
#include "database_aspect.h"
#include "database_field.h"
#include "iwr_page.h"
#include "label_paper.h"
#include "query.h"

struct label_spec_division
{
  char                                  m_tag[1+FIELD_NAME_MAX_LEN];
  enum iwr_page_section_type            m_type;
  struct item                           m_item;	
};

struct label_spec
{
  char*                                 m_reportfile;
  struct label_paper                    m_paper;
  struct database_aspect                m_aspect;
  struct query                          m_query;
  struct label_spec_division            m_report;
};

extern void
label_spec_assign(
  struct label_spec*const               o_label);

extern void
label_spec_discharge(
  struct label_spec*const               io_label);

extern int
label_spec_read(
  GError**                              o_error,
  struct label_spec*const               io_label,
  struct xml *const                     i_xml);

#define __label_spec_h__
#endif
